/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.integration.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.inject.Module;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jclouds.View;
import org.jclouds.apis.BaseViewLiveTest;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.domain.Location;
import org.jclouds.http.config.JavaUrlHttpCommandExecutorServiceModule;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.reflect.Reflection2;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;

public class BaseBlobStoreIntegrationTest
extends BaseViewLiveTest<BlobStoreContext> {
    protected static final String LOCAL_ENCODING = System.getProperty("file.encoding");
    protected static final String XML_STRING_FORMAT = "<apples><apple name=\"%s\"></apple> </apples>";
    protected static final String TEST_STRING = String.format("<apples><apple name=\"%s\"></apple> </apples>", "apple");
    protected Map<String, String> fiveStrings = ImmutableMap.of((Object)"one", (Object)String.format("<apples><apple name=\"%s\"></apple> </apples>", "apple"), (Object)"two", (Object)String.format("<apples><apple name=\"%s\"></apple> </apples>", "bear"), (Object)"three", (Object)String.format("<apples><apple name=\"%s\"></apple> </apples>", "candy"), (Object)"four", (Object)String.format("<apples><apple name=\"%s\"></apple> </apples>", "dogma"), (Object)"five", (Object)String.format("<apples><apple name=\"%s\"></apple> </apples>", "emma"));
    protected Map<String, String> fiveStringsUnderPath = ImmutableMap.of((Object)"path/1", (Object)String.format("<apples><apple name=\"%s\"></apple> </apples>", "apple"), (Object)"path/2", (Object)String.format("<apples><apple name=\"%s\"></apple> </apples>", "bear"), (Object)"path/3", (Object)String.format("<apples><apple name=\"%s\"></apple> </apples>", "candy"), (Object)"path/4", (Object)String.format("<apples><apple name=\"%s\"></apple> </apples>", "dogma"), (Object)"path/5", (Object)String.format("<apples><apple name=\"%s\"></apple> </apples>", "emma"));
    private static final Map<String, String> FILE_NESTED_STRINGS = ImmutableMap.of((Object)"path/1/a", (Object)String.format("<apples><apple name=\"%s\"></apple> </apples>", "apple"), (Object)"path/1/2/b", (Object)String.format("<apples><apple name=\"%s\"></apple> </apples>", "bear"), (Object)"path/1/2/3/c", (Object)String.format("<apples><apple name=\"%s\"></apple> </apples>", "candy"), (Object)"path/1/2/3/4/d", (Object)String.format("<apples><apple name=\"%s\"></apple> </apples>", "dog"), (Object)"path/1/2/3/5/e", (Object)String.format("<apples><apple name=\"%s\"></apple> </apples>", "echo"));
    public static long INCONSISTENCY_WINDOW = 10000L;
    protected static final AtomicInteger containerIndex = new AtomicInteger(0);
    protected static volatile int containerCount = Integer.parseInt(System.getProperty("test.blobstore.container-count", "10"));
    public static final String CONTAINER_PREFIX = (System.getProperty("user.name") + "-blobstore").toLowerCase();
    private static volatile BlockingQueue<String> containerNames = new ArrayBlockingQueue<String>(containerCount);
    protected static final int AWAIT_CONSISTENCY_TIMEOUT_SECONDS = Integer.parseInt(System.getProperty("test.blobstore.await-consistency-timeout-seconds", "10"));
    protected ListeningExecutorService exec;
    private static volatile boolean initialized = false;
    private static final Set<String> blackListContainers = Sets.newHashSet();
    public static boolean SANITY_CHECK_RETURNED_BUCKET_NAME = false;

    @BeforeSuite(groups={"integration", "live"})
    public void setUpResourcesForAllThreads(ITestContext testContext) throws Exception {
        this.setupContext();
        this.createContainersSharedByAllThreads((BlobStoreContext)this.view, testContext);
        ((BlobStoreContext)this.view).close();
        this.view = null;
    }

    @AfterSuite(groups={"integration", "live"})
    protected void destroyResources() throws Exception {
        this.setupContext();
        BaseBlobStoreIntegrationTest.deleteEverything((BlobStoreContext)this.view);
        ((BlobStoreContext)this.view).close();
        this.view = null;
    }

    protected Iterable<Module> setupModules() {
        return ImmutableSet.of((Object)this.getLoggingModule(), (Object)this.createHttpModule());
    }

    @BeforeClass(groups={"integration", "live"}, dependsOnMethods={"setupContext"})
    public void setUpResourcesOnThisThread(ITestContext testContext) throws Exception {
        this.exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDownContext() {
        if (this.exec != null) {
            this.exec.shutdownNow();
        }
        ((BlobStoreContext)this.view).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void createContainersSharedByAllThreads(BlobStoreContext context, ITestContext testContext) throws Exception {
        while (!initialized) {
            Class<BaseBlobStoreIntegrationTest> clazz = BaseBlobStoreIntegrationTest.class;
            // MONITORENTER : org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest.class
            if (!initialized) {
                BaseBlobStoreIntegrationTest.deleteEverything(context);
                while (containerIndex.get() < containerCount) {
                    String containerName = CONTAINER_PREFIX + containerIndex;
                    if (blackListContainers.contains(containerName)) {
                        ++containerCount;
                    } else {
                        try {
                            this.createContainerAndEnsureEmpty(context, containerName, false);
                            if (context.getBlobStore().containerExists(containerName)) {
                                containerNames.put(containerName);
                            } else {
                                BaseBlobStoreIntegrationTest.deleteContainerOrWarnIfUnable(context, containerName);
                                ++containerCount;
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            BaseBlobStoreIntegrationTest.deleteContainerOrWarnIfUnable(context, containerName);
                            ++containerCount;
                        }
                    }
                    containerIndex.incrementAndGet();
                }
                this.awaitConsistency();
                testContext.setAttribute("containerNames", containerNames);
                System.err.printf("*** containers to test: %s%n", containerNames);
                context.close();
                initialized = true;
            }
            // MONITOREXIT : clazz
        }
    }

    private static void deleteContainerOrWarnIfUnable(BlobStoreContext context, String containerName) {
        try {
            context.getBlobStore().deleteContainer(containerName);
        }
        catch (Throwable ex) {
            System.err.printf("unable to delete container %s, ignoring...%n", containerName);
            ex.printStackTrace();
            blackListContainers.add(containerName);
        }
    }

    protected static void deleteEverything(BlobStoreContext context) throws Exception {
        for (int i = 0; i < 2; ++i) {
            Iterable testContainers = Iterables.filter((Iterable)context.getBlobStore().list(), (Predicate)new Predicate<StorageMetadata>(){

                public boolean apply(StorageMetadata input) {
                    return (input.getType() == StorageType.CONTAINER || input.getType() == StorageType.FOLDER) && input.getName().startsWith(CONTAINER_PREFIX);
                }
            });
            for (StorageMetadata container : testContainers) {
                BaseBlobStoreIntegrationTest.deleteContainerOrWarnIfUnable(context, container.getName());
            }
        }
    }

    protected static void assertConsistencyAware(BlobStoreContext context, Runnable assertion) throws InterruptedException {
        if (context.getConsistencyModel() == ConsistencyModel.STRICT) {
            assertion.run();
            return;
        }
        AssertionError error = null;
        for (int i = 0; i < 30; ++i) {
            try {
                assertion.run();
                return;
            }
            catch (AssertionError e) {
                error = e;
                Thread.sleep(INCONSISTENCY_WINDOW / 30L);
                continue;
            }
        }
        if (error != null) {
            throw error;
        }
    }

    protected void assertConsistencyAware(Runnable assertion) throws InterruptedException {
        BaseBlobStoreIntegrationTest.assertConsistencyAware((BlobStoreContext)this.view, assertion);
    }

    protected void createContainerAndEnsureEmpty(BlobStoreContext context, String containerName, boolean ensureConsistent) throws InterruptedException {
        context.getBlobStore().createContainerInLocation(null, containerName);
        if (ensureConsistent) {
            this.awaitConsistency();
        }
        context.getBlobStore().clearContainer(containerName);
    }

    protected void createContainerAndEnsureEmpty(String containerName) throws InterruptedException {
        this.createContainerAndEnsureEmpty((BlobStoreContext)this.view, containerName, true);
    }

    protected String addBlobToContainer(String sourceContainer, String key) {
        return this.addBlobToContainer(sourceContainer, key, TEST_STRING, "text/xml");
    }

    protected String addBlobToContainer(String sourceContainer, String key, String payload, String contentType) {
        Blob sourceObject = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(key).payload(payload).contentType(contentType).build();
        return this.addBlobToContainer(sourceContainer, sourceObject);
    }

    protected void add5BlobsUnderPathAnd5UnderRootToContainer(String sourceContainer) {
        for (Map.Entry entry : Iterables.concat(this.fiveStrings.entrySet(), this.fiveStringsUnderPath.entrySet())) {
            Blob sourceObject = ((BlobStoreContext)this.view).getBlobStore().blobBuilder((String)entry.getKey()).payload((String)entry.getValue()).contentType("text/xml").build();
            this.addBlobToContainer(sourceContainer, sourceObject);
        }
    }

    protected void add5NestedBlobsToContainer(String sourceContainer) {
        for (Map.Entry<String, String> entry : FILE_NESTED_STRINGS.entrySet()) {
            Blob sourceObject = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(entry.getKey()).payload(entry.getValue()).contentType("text/xml").build();
            this.addBlobToContainer(sourceContainer, sourceObject);
        }
    }

    protected String addBlobToContainer(String sourceContainer, Blob object) {
        return ((BlobStoreContext)this.view).getBlobStore().putBlob(sourceContainer, object);
    }

    protected <T extends BlobMetadata> T validateMetadata(T md, String container, String name) {
        Assert.assertEquals((String)md.getName(), (String)name);
        Assert.assertEquals((String)md.getContainer(), (String)container);
        Assert.assertEquals((Object)md.getSize(), (Object)md.getContentMetadata().getContentLength());
        return md;
    }

    protected Blob validateContent(String container, String name) throws InterruptedException {
        this.assertConsistencyAwareContainerSize(container, 1);
        Blob newObject = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name);
        assert (newObject != null);
        this.validateMetadata(newObject.getMetadata(), container, name);
        try {
            Assert.assertEquals((String)BaseBlobStoreIntegrationTest.getContentAsStringOrNullAndClose(newObject), (String)TEST_STRING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return newObject;
    }

    protected void assertConsistencyAwareContainerSize(final String containerName, final int count) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                try {
                    assert (((BlobStoreContext)BaseBlobStoreIntegrationTest.this.view).getBlobStore().countBlobs(containerName) == (long)count) : String.format("expected only %d values in %s: %s", count, containerName, ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)((BlobStoreContext)BaseBlobStoreIntegrationTest.access$100(BaseBlobStoreIntegrationTest.this)).getBlobStore().list(containerName), (Function)new Function<StorageMetadata, String>(){

                        public String apply(StorageMetadata from) {
                            return from.getName();
                        }
                    })));
                }
                catch (Exception e) {
                    Throwables.propagateIfPossible((Throwable)e);
                }
            }
        });
    }

    protected void assertConsistencyAwareBlobExists(final String containerName, final String name) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                try {
                    assert (((BlobStoreContext)BaseBlobStoreIntegrationTest.this.view).getBlobStore().blobExists(containerName, name)) : String.format("could not find %s in %s: %s", name, containerName, ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)((BlobStoreContext)BaseBlobStoreIntegrationTest.access$300(BaseBlobStoreIntegrationTest.this)).getBlobStore().list(containerName), (Function)new Function<StorageMetadata, String>(){

                        public String apply(StorageMetadata from) {
                            return from.getName();
                        }
                    })));
                }
                catch (Exception e) {
                    Throwables.propagateIfPossible((Throwable)e);
                }
            }
        });
    }

    protected void assertConsistencyAwareBlobDoesntExist(final String containerName, final String name) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                try {
                    assert (!((BlobStoreContext)BaseBlobStoreIntegrationTest.this.view).getBlobStore().blobExists(containerName, name)) : String.format("found %s in %s", name, containerName);
                }
                catch (Exception e) {
                    Throwables.propagateIfPossible((Throwable)e);
                }
            }
        });
    }

    protected void assertConsistencyAwareContainerExists(final String containerName) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                try {
                    assert (((BlobStoreContext)BaseBlobStoreIntegrationTest.this.view).getBlobStore().containerExists(containerName)) : String.format("container %s doesn't exist", containerName);
                }
                catch (Exception e) {
                    Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    protected void assertConsistencyAwareContainerInLocation(final String containerName, final Location loc) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                try {
                    StorageMetadata container = (StorageMetadata)Iterables.find((Iterable)((BlobStoreContext)BaseBlobStoreIntegrationTest.this.view).getBlobStore().list(), (Predicate)new Predicate<StorageMetadata>(){

                        public boolean apply(@Nullable StorageMetadata input) {
                            return input.getName().equals(containerName);
                        }
                    });
                    Location actualLoc = container.getLocation();
                    assert (loc.equals(actualLoc)) : String.format("blob %s, in location %s instead of %s", containerName, actualLoc, loc);
                }
                catch (Exception e) {
                    Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    protected void assertConsistencyAwareBlobExpiryMetadata(final String containerName, final String blobName, final Date expectedExpires) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                try {
                    Blob blob = ((BlobStoreContext)BaseBlobStoreIntegrationTest.this.view).getBlobStore().getBlob(containerName, blobName);
                    Date actualExpires = blob.getPayload().getContentMetadata().getExpires();
                    assert (expectedExpires.equals(actualExpires)) : "expires=" + actualExpires + "; expected=" + expectedExpires;
                }
                catch (Exception e) {
                    Throwables.propagateIfPossible((Throwable)e);
                }
            }
        });
    }

    protected void assertConsistencyAwareBlobInLocation(final String containerName, final String blobName, final Location loc) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                try {
                    Location actualLoc = ((BlobStoreContext)BaseBlobStoreIntegrationTest.this.view).getBlobStore().getBlob(containerName, blobName).getMetadata().getLocation();
                    assert (loc.equals(actualLoc)) : String.format("blob %s in %s, in location %s instead of %s", blobName, containerName, actualLoc, loc);
                }
                catch (Exception e) {
                    Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    public String getContainerName() throws InterruptedException {
        String containerName = containerNames.poll(30L, TimeUnit.SECONDS);
        assert (containerName != null) : "unable to get a container for the test";
        this.createContainerAndEnsureEmpty(containerName);
        return containerName;
    }

    public String getScratchContainerName() throws InterruptedException {
        return this.allocateNewContainerName(this.getContainerName());
    }

    public void returnContainer(final String containerName) {
        if (containerName != null) {
            containerNames.add(containerName);
            if (SANITY_CHECK_RETURNED_BUCKET_NAME && !Iterables.any((Iterable)((BlobStoreContext)this.view).getBlobStore().list(), (Predicate)new Predicate<StorageMetadata>(){

                public boolean apply(StorageMetadata md) {
                    return containerName.equals(md.getName());
                }
            })) {
                throw new IllegalStateException("Test returned the name of a non-existent container: " + containerName);
            }
        }
    }

    protected void assertNotExists(final String containerName) throws InterruptedException {
        this.assertConsistencyAware(new Runnable(){

            @Override
            public void run() {
                try {
                    assert (!((BlobStoreContext)BaseBlobStoreIntegrationTest.this.view).getBlobStore().containerExists(containerName)) : "container " + containerName + " still exists";
                }
                catch (Exception e) {
                    Throwables.propagateIfPossible((Throwable)e);
                }
            }
        });
    }

    public void destroyContainer(String scratchContainer) throws InterruptedException {
        if (scratchContainer != null) {
            this.recycleContainerAndAddToPool(scratchContainer);
        }
    }

    protected void recycleContainerAndAddToPool(String scratchContainer) throws InterruptedException {
        String newScratchContainer = this.recycleContainer(scratchContainer);
        this.returnContainer(newScratchContainer);
    }

    protected String recycleContainer(String container) throws InterruptedException {
        String newScratchContainer = this.allocateNewContainerName(container);
        this.createContainerAndEnsureEmpty(newScratchContainer);
        return newScratchContainer;
    }

    private String allocateNewContainerName(final String container) {
        this.exec.submit(new Runnable(){

            @Override
            public void run() {
                BaseBlobStoreIntegrationTest.deleteContainerOrWarnIfUnable((BlobStoreContext)BaseBlobStoreIntegrationTest.this.view, container);
            }
        });
        String newScratchContainer = CONTAINER_PREFIX + containerIndex.incrementAndGet();
        System.err.printf("*** allocated new container %s...%n", newScratchContainer);
        return newScratchContainer;
    }

    public static String getContentAsStringOrNullAndClose(Blob blob) throws IOException {
        Preconditions.checkNotNull((Object)blob, (Object)"blob");
        Preconditions.checkNotNull((Object)blob.getPayload(), (Object)"blob.payload");
        return Strings2.toStringAndClose((InputStream)blob.getPayload().openStream());
    }

    protected Module createHttpModule() {
        return new JavaUrlHttpCommandExecutorServiceModule();
    }

    protected TypeToken<BlobStoreContext> viewType() {
        return Reflection2.typeToken(BlobStoreContext.class);
    }

    protected void awaitConsistency() {
        if (((BlobStoreContext)this.view).getConsistencyModel() == ConsistencyModel.EVENTUAL) {
            Uninterruptibles.sleepUninterruptibly((long)AWAIT_CONSISTENCY_TIMEOUT_SECONDS, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    static /* synthetic */ View access$100(BaseBlobStoreIntegrationTest x0) {
        return x0.view;
    }

    static /* synthetic */ View access$300(BaseBlobStoreIntegrationTest x0) {
        return x0.view;
    }
}

