/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.integration.internal;

import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class BaseBlobSignerLiveTest
extends BaseBlobStoreIntegrationTest {
    protected int getSignedUrlTimeout() {
        return 60;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignGetUrl() throws Exception {
        String name = "hello";
        String text = "fooooooooooooooooooooooo";
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(text).contentType("text/plain").build();
        String container = this.getContainerName();
        try {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob);
            this.assertConsistencyAwareContainerSize(container, 1);
            HttpRequest request = ((BlobStoreContext)this.view).getSigner().signGetBlob(container, name);
            Assert.assertEquals((int)request.getFilters().size(), (int)0);
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)((BlobStoreContext)this.view).utils().http().invoke(request).getPayload().openStream()), (String)text);
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignGetUrlOptions() throws Exception {
        String name = "hello";
        String text = "fooooooooooooooooooooooo";
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(text).contentType("text/plain").build();
        String container = this.getContainerName();
        try {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob);
            this.assertConsistencyAwareContainerSize(container, 1);
            HttpRequest request = ((BlobStoreContext)this.view).getSigner().signGetBlob(container, name, GetOptions.Builder.range((long)0L, (long)1L));
            Assert.assertEquals((int)request.getFilters().size(), (int)0);
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)((BlobStoreContext)this.view).utils().http().invoke(request).getPayload().openStream()), (String)"fo");
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignGetUrlWithTime() throws InterruptedException, IOException {
        String name = "hello";
        String text = "fooooooooooooooooooooooo";
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(text).contentType("text/plain").build();
        String container = this.getContainerName();
        try {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob);
            this.assertConsistencyAwareContainerSize(container, 1);
            HttpRequest request = ((BlobStoreContext)this.view).getSigner().signGetBlob(container, name, (long)this.getSignedUrlTimeout());
            Assert.assertEquals((int)request.getFilters().size(), (int)0);
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)((BlobStoreContext)this.view).utils().http().invoke(request).getPayload().openStream()), (String)text);
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSignGetUrlWithTime(long timeout) throws InterruptedException, IOException {
        String name = "hello";
        String text = "fooooooooooooooooooooooo";
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(text).contentType("text/plain").build();
        String container = this.getContainerName();
        try {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob);
            this.assertConsistencyAwareContainerSize(container, 1);
            HttpRequest request = ((BlobStoreContext)this.view).getSigner().signGetBlob(container, name, timeout);
            Assert.assertEquals((int)request.getFilters().size(), (int)0);
            try {
                Strings2.toStringAndClose((InputStream)((BlobStoreContext)this.view).utils().http().invoke(request).getPayload().openStream());
                Assert.fail((String)"Temporary URL did not expire as expected");
            }
            catch (AuthorizationException authorizationException) {
                // empty catch block
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    @Test
    public void testSignGetUrlWithTimeExpired() throws InterruptedException, IOException {
        this.testSignGetUrlWithTime(-this.getSignedUrlTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignPutUrl() throws Exception {
        String name = "hello";
        String text = "fooooooooooooooooooooooo";
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(text).contentType("image/png").build();
        String container = this.getContainerName();
        try {
            HttpRequest request = ((BlobStoreContext)this.view).getSigner().signPutBlob(container, blob);
            Assert.assertEquals((int)request.getFilters().size(), (int)0);
            Strings2.toStringAndClose((InputStream)((BlobStoreContext)this.view).utils().http().invoke(request).getPayload().openStream());
            blob = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name);
            Assertions.assertThat((String)blob.getMetadata().getContentMetadata().getContentType()).isEqualTo((Object)"image/png");
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignPutUrlWithTime() throws Exception {
        String name = "hello";
        String text = "fooooooooooooooooooooooo";
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(text).contentType("text/plain").build();
        String container = this.getContainerName();
        try {
            HttpRequest request = ((BlobStoreContext)this.view).getSigner().signPutBlob(container, blob, (long)this.getSignedUrlTimeout());
            Assert.assertEquals((int)request.getFilters().size(), (int)0);
            request = ((HttpRequest.Builder)request.toBuilder().removeHeader("Expect")).build();
            Strings2.toStringAndClose((InputStream)((BlobStoreContext)this.view).utils().http().invoke(request).getPayload().openStream());
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSignPutUrlWithTime(long timeout) throws InterruptedException, IOException {
        String name = "hello";
        String text = "fooooooooooooooooooooooo";
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(text).contentType("text/plain").build();
        String container = this.getContainerName();
        try {
            HttpRequest request = ((BlobStoreContext)this.view).getSigner().signPutBlob(container, blob, 0L);
            Assert.assertEquals((int)request.getFilters().size(), (int)0);
            request = ((HttpRequest.Builder)request.toBuilder().removeHeader("Expect")).build();
            try {
                Strings2.toStringAndClose((InputStream)((BlobStoreContext)this.view).utils().http().invoke(request).getPayload().openStream());
                Assert.fail((String)"Temporary URL did not expire as expected");
            }
            catch (AuthorizationException authorizationException) {
                // empty catch block
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    @Test
    public void testSignPutUrlWithTimeExpired() throws Exception {
        this.testSignPutUrlWithTime(-this.getSignedUrlTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSignRemoveUrl() throws Exception {
        String name = "hello";
        String text = "fooooooooooooooooooooooo";
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(text).contentType("text/plain").build();
        String container = this.getContainerName();
        try {
            ((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob);
            this.awaitConsistency();
            this.assertConsistencyAwareContainerSize(container, 1);
            HttpRequest request = ((BlobStoreContext)this.view).getSigner().signRemoveBlob(container, name);
            Assert.assertEquals((int)request.getFilters().size(), (int)0);
            ((BlobStoreContext)this.view).utils().http().invoke(request);
            assert (!((BlobStoreContext)this.view).getBlobStore().blobExists(container, name));
        }
        finally {
            this.returnContainer(container);
        }
    }

    @Override
    protected void awaitConsistency() {
        if (((BlobStoreContext)this.view).getConsistencyModel() == ConsistencyModel.EVENTUAL) {
            Uninterruptibles.sleepUninterruptibly((long)AWAIT_CONSISTENCY_TIMEOUT_SECONDS, (TimeUnit)TimeUnit.SECONDS);
        }
    }
}

