/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.integration.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.Tier;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.internal.MultipartUploadSlicingAlgorithm;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.crypto.Crypto;
import org.jclouds.encryption.internal.JCECrypto;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.io.ByteStreams2;
import org.jclouds.io.ContentMetadataBuilder;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.logging.Logger;
import org.jclouds.util.Closeables2;
import org.jclouds.utils.TestUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class BaseBlobIntegrationTest
extends BaseBlobStoreIntegrationTest {
    private static final ByteSource oneHundredOneConstitutions = TestUtils.randomByteSource().slice(0L, 4556918L);
    protected static volatile Crypto crypto;

    @Override
    @BeforeClass(groups={"integration", "live"}, dependsOnMethods={"setupContext"})
    public void setUpResourcesOnThisThread(ITestContext testContext) throws Exception {
        super.setUpResourcesOnThisThread(testContext);
    }

    public static ByteSource getTestDataSupplier() throws IOException {
        return oneHundredOneConstitutions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testPutBlobParallel() throws Exception {
        final ByteSource expected = BaseBlobIntegrationTest.createTestInput(32768);
        final String container = this.getContainerName();
        try {
            HashMap responses = Maps.newHashMap();
            for (int i = 0; i < 3; ++i) {
                final String name = String.valueOf(i);
                responses.put(i, this.exec.submit((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ByteSourcePayload payload = Payloads.newByteSourcePayload((ByteSource)expected);
                        payload.getContentMetadata().setContentType("image/png");
                        Blob blob = ((BlobStoreContext)BaseBlobIntegrationTest.this.view).getBlobStore().blobBuilder(name).payload((Payload)payload).contentLength(expected.size()).build();
                        ((BlobStoreContext)BaseBlobIntegrationTest.this.view).getBlobStore().putBlob(container, blob);
                        BaseBlobIntegrationTest.this.assertConsistencyAwareBlobExists(container, name);
                        blob = ((BlobStoreContext)BaseBlobIntegrationTest.this.view).getBlobStore().getBlob(container, name);
                        byte[] actual = ByteStreams2.toByteArrayAndClose((InputStream)blob.getPayload().openStream());
                        Assertions.assertThat((byte[])actual).isEqualTo((Object)expected.read());
                        ((BlobStoreContext)BaseBlobIntegrationTest.this.view).getBlobStore().removeBlob(container, name);
                        BaseBlobIntegrationTest.this.assertConsistencyAwareBlobDoesntExist(container, name);
                        return null;
                    }
                }));
            }
            Map exceptions = FutureIterables.awaitCompletion((Map)responses, (ListeningExecutorService)this.exec, (Long)30000L, (Logger)Logger.CONSOLE, (String)"putFileParallel");
            assert (exceptions.size() == 0) : exceptions;
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testFileGetParallel() throws Exception {
        final ByteSource supplier = BaseBlobIntegrationTest.createTestInput(32768);
        final String container = this.getContainerName();
        try {
            String name = "constitution.txt";
            this.uploadByteSource(container, "constitution.txt", supplier);
            HashMap responses = Maps.newHashMap();
            for (int i = 0; i < 10; ++i) {
                responses.put(i, this.exec.submit((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            Blob blob = ((BlobStoreContext)BaseBlobIntegrationTest.this.view).getBlobStore().getBlob(container, "constitution.txt");
                            BaseBlobIntegrationTest.this.validateMetadata(blob.getMetadata(), container, "constitution.txt");
                            Assert.assertEquals((Object)ByteStreams2.hashAndClose((InputStream)blob.getPayload().openStream(), (HashFunction)Hashing.md5()), (Object)supplier.hash(Hashing.md5()));
                        }
                        catch (IOException e) {
                            Throwables.propagate((Throwable)e);
                        }
                        return null;
                    }
                }));
            }
            Map exceptions = FutureIterables.awaitCompletion((Map)responses, (ListeningExecutorService)this.exec, (Long)30000L, (Logger)Logger.CONSOLE, (String)"get constitution");
            if (!exceptions.isEmpty()) {
                throw (Exception)exceptions.values().iterator().next();
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    private void uploadByteSource(String container, String name, ByteSource byteSource) throws IOException {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        blobStore.putBlob(container, blobStore.blobBuilder(name).payload((Payload)new ByteSourcePayload(byteSource)).contentType("text/plain").contentMD5(byteSource.hash(Hashing.md5())).contentLength(byteSource.size()).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetIfModifiedSince() throws InterruptedException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            Date before = new Date(System.currentTimeMillis() - 1000L);
            this.addObjectAndValidateContent(container, name);
            this.addObjectAndValidateContent(container, name);
            Date after = new Date(System.currentTimeMillis() + 1000L);
            ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifModifiedSince((Date)before));
            this.validateContent(container, name);
            try {
                ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifModifiedSince((Date)after));
                this.validateContent(container, name);
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)304);
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testOverwriteBlob() throws InterruptedException {
        String container = this.getContainerName();
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        try {
            String blobName = "hello";
            Blob blob = blobStore.blobBuilder(blobName).payload(TEST_STRING).build();
            blobStore.putBlob(container, blob);
            Blob overwriteBlob = blobStore.blobBuilder(blobName).payload("overwrite content").build();
            blobStore.putBlob(container, overwriteBlob);
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testCreateBlobWithExpiry() throws InterruptedException {
        String container = this.getContainerName();
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        try {
            String blobName = "hello";
            Date expires = new Date(System.currentTimeMillis() / 1000L * 1000L + 60000L);
            blobStore.putBlob(container, blobStore.blobBuilder("hello").payload(TEST_STRING).expires(expires).build());
            this.assertConsistencyAwareBlobExpiryMetadata(container, "hello", expires);
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putBlobWithMd5(byte[] payload, HashCode contentMD5) throws InterruptedException, IOException {
        String container = this.getContainerName();
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        try {
            String blobName = "putBlobWithMd5-" + new Random().nextLong();
            Blob blob = blobStore.blobBuilder(blobName).payload(payload).contentMD5(contentMD5).build();
            blobStore.putBlob(container, blob);
        }
        finally {
            this.returnContainer(container);
        }
    }

    protected int getIncorrectContentMD5StatusCode() {
        return 400;
    }

    @Test(groups={"integration", "live"})
    public void testPutCorrectContentMD5() throws InterruptedException, IOException {
        byte[] payload = BaseBlobIntegrationTest.createTestInput(1024).read();
        HashCode contentMD5 = Hashing.md5().hashBytes(payload);
        this.putBlobWithMd5(payload, contentMD5);
    }

    @Test(groups={"integration", "live"})
    public void testPutIncorrectContentMD5() throws InterruptedException, IOException {
        block2: {
            byte[] payload = BaseBlobIntegrationTest.createTestInput(1024).read();
            HashCode contentMD5 = Hashing.md5().hashBytes(new byte[0]);
            try {
                this.putBlobWithMd5(payload, contentMD5);
                Assert.fail();
            }
            catch (HttpResponseException hre) {
                if (hre.getResponse().getStatusCode() == this.getIncorrectContentMD5StatusCode()) break block2;
                throw hre;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetIfUnmodifiedSince() throws InterruptedException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            Date before = new Date(System.currentTimeMillis() - 10000L);
            this.addObjectAndValidateContent(container, name);
            Date after = new Date(System.currentTimeMillis() + 10000L);
            this.awaitConsistency();
            ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifUnmodifiedSince((Date)after));
            this.validateContent(container, name);
            try {
                ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifUnmodifiedSince((Date)before));
                this.validateContent(container, name);
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)412);
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetIfMatch() throws InterruptedException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            String goodETag = this.addObjectAndValidateContent(container, name);
            ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifETagMatches((String)goodETag));
            this.validateContent(container, name);
            try {
                ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifETagMatches((String)"powerfrisbee"));
                this.validateContent(container, name);
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)412);
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetIfNoneMatch() throws InterruptedException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            String goodETag = this.addObjectAndValidateContent(container, name);
            ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifETagDoesntMatch((String)"powerfrisbee"));
            this.validateContent(container, name);
            try {
                ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.ifETagDoesntMatch((String)goodETag));
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((int)ex.getResponse().getStatusCode(), (int)304);
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetRangeOutOfRange() throws InterruptedException, IOException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            this.addObjectAndValidateContent(container, name);
            try {
                ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.range((long)TEST_STRING.length(), (long)(TEST_STRING.length() + 1)));
                Fail.failBecauseExceptionWasNotThrown(HttpResponseException.class);
            }
            catch (HttpResponseException e) {
                Assertions.assertThat((int)e.getResponse().getStatusCode()).isEqualTo(416);
            }
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetRange() throws InterruptedException, IOException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            this.addObjectAndValidateContent(container, name);
            Blob blob1 = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.range((long)0L, (long)5L));
            this.validateMetadata(blob1.getMetadata(), container, name);
            Assert.assertEquals((String)BaseBlobIntegrationTest.getContentAsStringOrNullAndClose(blob1), (String)TEST_STRING.substring(0, 6));
            Assertions.assertThat((Iterable)blob1.getAllHeaders().get((Object)"Content-Range")).containsExactly((Object[])new String[]{"bytes 0-5/46"});
            Blob blob2 = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.range((long)6L, (long)TEST_STRING.length()));
            this.validateMetadata(blob2.getMetadata(), container, name);
            Assert.assertEquals((String)BaseBlobIntegrationTest.getContentAsStringOrNullAndClose(blob2), (String)TEST_STRING.substring(6, TEST_STRING.length()));
            Assertions.assertThat((Iterable)blob2.getAllHeaders().get((Object)"Content-Range")).containsExactly((Object[])new String[]{"bytes 6-45/46"});
            Blob blob3 = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, new GetOptions().tail((long)(TEST_STRING.length() + 10)));
            this.validateMetadata(blob3.getMetadata(), container, name);
            Assert.assertEquals((String)BaseBlobIntegrationTest.getContentAsStringOrNullAndClose(blob3), (String)TEST_STRING);
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetTwoRanges() throws InterruptedException, IOException {
        String container = this.getContainerName();
        try {
            String name = "apples";
            this.addObjectAndValidateContent(container, name);
            Blob blob = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.range((long)0L, (long)5L).range(6L, (long)TEST_STRING.length()));
            this.validateMetadata(blob.getMetadata(), container, name);
            Assert.assertEquals((String)BaseBlobIntegrationTest.getContentAsStringOrNullAndClose(blob), (String)TEST_STRING);
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testGetRangeMultipart() throws InterruptedException, IOException {
        String container = this.getContainerName();
        InputStream expect = null;
        InputStream actual = null;
        try {
            String name = "apples";
            long length = this.getMinimumMultipartBlobSize();
            ByteSource byteSource = TestUtils.randomByteSource().slice(0L, length);
            Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(byteSource).contentLength(length).build();
            ((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob, new PutOptions().multipart(true));
            blob = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, name, GetOptions.Builder.range((long)0L, (long)5L));
            this.validateMetadata(blob.getMetadata(), container, name);
            expect = byteSource.slice(0L, 6L).openStream();
            actual = blob.getPayload().openStream();
            Assertions.assertThat((InputStream)actual).hasContentEqualTo(expect);
        }
        catch (Throwable throwable) {
            Closeables2.closeQuietly(expect);
            Closeables2.closeQuietly(actual);
            this.returnContainer(container);
            throw throwable;
        }
        Closeables2.closeQuietly((Closeable)expect);
        Closeables2.closeQuietly((Closeable)actual);
        this.returnContainer(container);
    }

    private String addObjectAndValidateContent(String sourcecontainer, String sourceKey) throws InterruptedException {
        String eTag = this.addBlobToContainer(sourcecontainer, sourceKey);
        this.validateContent(sourcecontainer, sourceKey);
        this.awaitConsistency();
        return eTag;
    }

    @Test(groups={"integration", "live"})
    public void deleteObjectNotFound() throws InterruptedException {
        String container = this.getContainerName();
        String name = "test";
        try {
            ((BlobStoreContext)this.view).getBlobStore().removeBlob(container, name);
        }
        finally {
            this.returnContainer(container);
        }
    }

    @Test(groups={"integration", "live"})
    public void blobNotFound() throws InterruptedException {
        String container = this.getContainerName();
        String name = "test";
        try {
            assert (!((BlobStoreContext)this.view).getBlobStore().blobExists(container, name));
        }
        finally {
            this.returnContainer(container);
        }
    }

    @DataProvider(name="delete")
    public Object[][] createData() {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            return new Object[][]{{"normal"}, {"sp ace"}};
        }
        return new Object[][]{{"normal"}, {"sp ace"}, {"qu?stion"}, {"unic\u20aade"}, {"path/foo"}, {"colon:"}, {"asteri*k"}, {"quote\""}, {"{great<r}"}, {"lesst>en"}, {"p|pe"}};
    }

    @Test(groups={"integration", "live"}, dataProvider="delete")
    public void deleteObject(String name) throws InterruptedException {
        String container = this.getContainerName();
        try {
            this.addBlobToContainer(container, name, name, "text/plain");
            this.awaitConsistency();
            ((BlobStoreContext)this.view).getBlobStore().removeBlob(container, name);
            this.awaitConsistency();
            this.assertContainerEmptyDeleting(container, name);
        }
        finally {
            this.returnContainer(container);
        }
    }

    private void assertContainerEmptyDeleting(String container, String name) {
        Iterable listing = Iterables.filter((Iterable)((BlobStoreContext)this.view).getBlobStore().list(container), (Predicate)new Predicate<StorageMetadata>(){

            public boolean apply(StorageMetadata input) {
                return input.getType() == StorageType.BLOB;
            }
        });
        Assert.assertEquals((int)Iterables.size((Iterable)listing), (int)0, (String)String.format("deleting %s, we still have %s blobs left in container %s, using encoding %s", name, Iterables.size((Iterable)listing), container, LOCAL_ENCODING));
    }

    @Test(groups={"integration", "live"})
    public void deleteObjectNoContainer() {
        try {
            ((BlobStoreContext)this.view).getBlobStore().removeBlob("donb", "test");
        }
        catch (HttpResponseException e) {
            Assert.assertEquals((int)e.getResponse().getStatusCode(), (int)404);
        }
        catch (ContainerNotFoundException containerNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"}, dataProvider="delete")
    public void deleteMultipleObjects(String name) throws InterruptedException {
        String name2 = name + "2";
        String container = this.getContainerName();
        try {
            this.addBlobToContainer(container, name, name, "text/plain");
            this.addBlobToContainer(container, name2, name2, "text/plain");
            this.awaitConsistency();
            ((BlobStoreContext)this.view).getBlobStore().removeBlobs(container, (Iterable)ImmutableSet.of((Object)name, (Object)name2));
            this.awaitConsistency();
            this.assertContainerEmptyDeleting(container, name);
        }
        finally {
            this.returnContainer(container);
        }
    }

    @DataProvider(name="putTests")
    public Object[][] createData1() throws IOException {
        File file = new File("pom.xml");
        String realObject = Files.toString((File)file, (Charset)Charsets.UTF_8);
        return new Object[][]{{"file", "text/xml", file, realObject}, {"string", "text/xml", realObject, realObject}, {"bytes", "application/octet-stream", realObject.getBytes(), realObject}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"}, dataProvider="putTests")
    public void testPutObject(String name, String type, Object content, Object realObject) throws InterruptedException, IOException {
        BlobBuilder.PayloadBlobBuilder blobBuilder = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).payload(Payloads.newPayload((Object)content)).contentType(type);
        this.addContentMetadata(blobBuilder);
        Blob blob = blobBuilder.build();
        String container = this.getContainerName();
        try {
            Assert.assertNotNull((Object)((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob));
            this.awaitConsistency();
            blob = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, blob.getMetadata().getName());
            this.validateMetadata(blob.getMetadata(), container, name);
            this.checkContentMetadata(blob);
            String returnedString = BaseBlobIntegrationTest.getContentAsStringOrNullAndClose(blob);
            Assert.assertEquals((Object)returnedString, (Object)realObject);
            PageSet set = ((BlobStoreContext)this.view).getBlobStore().list(container);
            assert (set.size() == 1) : set;
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testPutObjectStream() throws InterruptedException, IOException, ExecutionException {
        BlobBuilder.PayloadBlobBuilder blobBuilder = ((BlobStoreContext)this.view).getBlobStore().blobBuilder("streaming").payload((Payload)new ByteSourcePayload(ByteSource.wrap((byte[])"foo".getBytes())));
        this.addContentMetadata(blobBuilder);
        Blob blob = blobBuilder.build();
        String container = this.getContainerName();
        try {
            Assert.assertNotNull((Object)((BlobStoreContext)this.view).getBlobStore().putBlob(container, blob));
            this.awaitConsistency();
            blob = ((BlobStoreContext)this.view).getBlobStore().getBlob(container, blob.getMetadata().getName());
            String returnedString = BaseBlobIntegrationTest.getContentAsStringOrNullAndClose(blob);
            Assert.assertEquals((String)returnedString, (String)"foo");
            this.validateMetadata(blob.getMetadata(), container, blob.getMetadata().getName());
            this.checkContentMetadata(blob);
            PageSet set = ((BlobStoreContext)this.view).getBlobStore().list(container);
            assert (set.size() == 1) : set;
        }
        finally {
            this.returnContainer(container);
        }
    }

    @Test(groups={"integration", "live"})
    public void testPutByteSource() throws Exception {
        long length = 42L;
        ByteSource byteSource = TestUtils.randomByteSource().slice(0L, length);
        ByteSourcePayload payload = new ByteSourcePayload(byteSource);
        this.testPut((Payload)payload, null, (Payload)payload, length, new PutOptions());
    }

    @Test(groups={"integration", "live"})
    public void testPutInputStream() throws Exception {
        long length = 42L;
        ByteSource byteSource = TestUtils.randomByteSource().slice(0L, length);
        InputStreamPayload payload = new InputStreamPayload(byteSource.openStream());
        this.testPut((Payload)payload, null, (Payload)new ByteSourcePayload(byteSource), length, new PutOptions());
    }

    @Test(groups={"integration", "live"})
    public void testPutZeroLengthByteSource() throws Exception {
        long length = 0L;
        ByteSource byteSource = TestUtils.randomByteSource().slice(0L, length);
        ByteSourcePayload payload = new ByteSourcePayload(byteSource);
        this.testPut((Payload)payload, null, (Payload)payload, length, new PutOptions());
    }

    @Test(groups={"integration", "live"})
    public void testPutZeroLengthInputStream() throws Exception {
        long length = 0L;
        ByteSource byteSource = TestUtils.randomByteSource().slice(0L, length);
        InputStreamPayload payload = new InputStreamPayload(byteSource.openStream());
        this.testPut((Payload)payload, null, (Payload)payload, length, new PutOptions());
    }

    @Test(groups={"integration", "live"})
    public void testPutMultipartByteSource() throws Exception {
        long length = Math.max(this.getMinimumMultipartBlobSize(), 0x2000001L);
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        MultipartUploadSlicingAlgorithm algorithm = new MultipartUploadSlicingAlgorithm(blobStore.getMinimumMultipartPartSize(), blobStore.getMaximumMultipartPartSize(), blobStore.getMaximumNumberOfParts());
        Assertions.assertThat((long)algorithm.calculateChunkSize(length)).isLessThan(length);
        ByteSource byteSource = TestUtils.randomByteSource().slice(0L, length);
        ByteSourcePayload payload = new ByteSourcePayload(byteSource);
        HashCode hashCode = byteSource.hash(Hashing.md5());
        this.testPut((Payload)payload, hashCode, (Payload)payload, length, new PutOptions().multipart(true));
    }

    @Test(groups={"integration", "live"})
    public void testPutMultipartInputStream() throws Exception {
        long length = Math.max(this.getMinimumMultipartBlobSize(), 0x2000001L);
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        MultipartUploadSlicingAlgorithm algorithm = new MultipartUploadSlicingAlgorithm(blobStore.getMinimumMultipartPartSize(), blobStore.getMaximumMultipartPartSize(), blobStore.getMaximumNumberOfParts());
        Assertions.assertThat((long)algorithm.calculateChunkSize(length)).isLessThan(length);
        ByteSource byteSource = TestUtils.randomByteSource().slice(0L, length);
        InputStreamPayload payload = new InputStreamPayload(byteSource.openStream());
        this.testPut((Payload)payload, null, (Payload)new ByteSourcePayload(byteSource), length, new PutOptions().multipart(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testSetBlobAccess() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String containerName = this.getContainerName();
        String blobName = "set-access-blob-name";
        try {
            this.addBlobToContainer(containerName, blobName, blobName, "text/plain");
            Assertions.assertThat((Comparable)blobStore.getBlobAccess(containerName, blobName)).isEqualTo((Object)BlobAccess.PRIVATE);
            blobStore.setBlobAccess(containerName, blobName, BlobAccess.PUBLIC_READ);
            Assertions.assertThat((Comparable)blobStore.getBlobAccess(containerName, blobName)).isEqualTo((Object)BlobAccess.PUBLIC_READ);
            HttpRequest request = ((BlobStoreContext)this.view).getSigner().signGetBlob(containerName, blobName).toBuilder().replaceQueryParams((Map)ImmutableMap.of()).build();
            HttpResponse response = ((BlobStoreContext)this.view).utils().http().invoke(request);
            Assertions.assertThat((int)response.getStatusCode()).isEqualTo(200);
            blobStore.setBlobAccess(containerName, blobName, BlobAccess.PRIVATE);
            Assertions.assertThat((Comparable)blobStore.getBlobAccess(containerName, blobName)).isEqualTo((Object)BlobAccess.PRIVATE);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testPutBlobAccess() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String containerName = this.getContainerName();
        try {
            String blobNamePrivate = "put-access-blob-name-private";
            Blob blobPrivate = blobStore.blobBuilder(blobNamePrivate).payload(new byte[1]).build();
            blobStore.putBlob(containerName, blobPrivate, new PutOptions().setBlobAccess(BlobAccess.PRIVATE));
            Assertions.assertThat((Comparable)blobStore.getBlobAccess(containerName, blobNamePrivate)).isEqualTo((Object)BlobAccess.PRIVATE);
            String blobNamePublic = "put-access-blob-name-public";
            Blob blobPublic = blobStore.blobBuilder(blobNamePublic).payload(new byte[1]).build();
            blobStore.putBlob(containerName, blobPublic, new PutOptions().setBlobAccess(BlobAccess.PUBLIC_READ));
            Assertions.assertThat((Comparable)blobStore.getBlobAccess(containerName, blobNamePublic)).isEqualTo((Object)BlobAccess.PUBLIC_READ);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testPutBlobAccessMultipart() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String containerName = this.getContainerName();
        ByteSource byteSource = TestUtils.randomByteSource().slice(0L, this.getMinimumMultipartBlobSize());
        ByteSourcePayload payload = Payloads.newByteSourcePayload((ByteSource)byteSource);
        payload.getContentMetadata().setContentLength(Long.valueOf(byteSource.size()));
        try {
            String blobNamePrivate = "put-access-blob-name-private";
            Blob blobPrivate = blobStore.blobBuilder(blobNamePrivate).payload((Payload)payload).build();
            blobStore.putBlob(containerName, blobPrivate, new PutOptions().setBlobAccess(BlobAccess.PRIVATE).multipart(true));
            Assertions.assertThat((Comparable)blobStore.getBlobAccess(containerName, blobNamePrivate)).isEqualTo((Object)BlobAccess.PRIVATE);
            String blobNamePublic = "put-access-blob-name-public";
            Blob blobPublic = blobStore.blobBuilder(blobNamePublic).payload((Payload)payload).build();
            blobStore.putBlob(containerName, blobPublic, new PutOptions().setBlobAccess(BlobAccess.PUBLIC_READ).multipart(true));
            Assertions.assertThat((Comparable)blobStore.getBlobAccess(containerName, blobNamePublic)).isEqualTo((Object)BlobAccess.PUBLIC_READ);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    @Test(groups={"integration", "live"})
    public void testPutBlobTierStandard() throws Exception {
        this.testPutBlobTierHelper(Tier.STANDARD, new PutOptions());
    }

    @Test(groups={"integration", "live"})
    public void testPutBlobTierInfrequent() throws Exception {
        this.testPutBlobTierHelper(Tier.INFREQUENT, new PutOptions());
    }

    @Test(groups={"integration", "live"})
    public void testPutBlobTierArchive() throws Exception {
        this.testPutBlobTierHelper(Tier.ARCHIVE, new PutOptions());
    }

    @Test(groups={"integration", "live"})
    public void testPutBlobTierStandardMultipart() throws Exception {
        this.testPutBlobTierHelper(Tier.STANDARD, new PutOptions().multipart(true));
    }

    @Test(groups={"integration", "live"})
    public void testPutBlobTierInfrequentMultipart() throws Exception {
        this.testPutBlobTierHelper(Tier.INFREQUENT, new PutOptions().multipart(true));
    }

    @Test(groups={"integration", "live"})
    public void testPutBlobTierArchiveMultipart() throws Exception {
        this.testPutBlobTierHelper(Tier.ARCHIVE, new PutOptions().multipart(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testPutBlobTierHelper(Tier tier, PutOptions options) throws Exception {
        String blobName = "put-blob-tier-" + tier;
        ByteSource payload = BaseBlobIntegrationTest.createTestInput(1024);
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String containerName = this.getContainerName();
        try {
            Blob blob = blobStore.blobBuilder(blobName).payload(payload).contentLength(payload.size()).tier(tier).build();
            blobStore.putBlob(containerName, blob, options);
            this.checkTier(blobStore.blobMetadata(containerName, blobName), tier);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    protected void checkTier(BlobMetadata metadata, Tier expected) {
        Assertions.assertThat((Comparable)metadata.getTier()).isEqualTo((Object)expected);
    }

    protected void checkUserMetadata(Map<String, String> userMetadata1, Map<String, String> userMetadata2) {
        Assertions.assertThat(userMetadata1).isEqualTo(userMetadata2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPut(Payload payload, HashCode hashCode, Payload expectedPayload, long length, PutOptions options) throws IOException, InterruptedException {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String blobName = "multipart-upload";
        ImmutableMap userMetadata = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2");
        BlobBuilder.PayloadBlobBuilder blobBuilder = blobStore.blobBuilder(blobName).userMetadata((Map)userMetadata).payload(payload).contentLength(length);
        this.addContentMetadata(blobBuilder);
        if (hashCode != null) {
            blobBuilder.contentMD5(payload.getContentMetadata().getContentMD5AsHashCode());
        }
        String container = this.getContainerName();
        try {
            String etag = blobStore.putBlob(container, blobBuilder.build(), options);
            Assertions.assertThat((String)etag).isNotNull();
            Blob blob = blobStore.getBlob(container, blobName);
            Assertions.assertThat((Long)blob.getMetadata().getContentMetadata().getContentLength()).isEqualTo(length);
            InputStream is = null;
            try {
                is = blob.getPayload().openStream();
                Assertions.assertThat((InputStream)is).hasContentEqualTo(expectedPayload.openStream());
            }
            finally {
                Closeables2.closeQuietly((Closeable)is);
            }
            this.validateMetadata(blob.getMetadata(), container, blob.getMetadata().getName());
            this.checkContentMetadata(blob);
            this.checkUserMetadata(blob.getMetadata().getUserMetadata(), (Map<String, String>)userMetadata);
        }
        finally {
            this.returnContainer(container);
        }
    }

    protected long getMinimumMultipartBlobSize() {
        throw new SkipException("multipart upload not supported");
    }

    protected void checkContentMetadata(Blob blob) {
        this.checkCacheControl(blob, "max-age=3600");
        this.checkContentType(blob, "text/csv");
        this.checkContentDisposition(blob, "attachment; filename=photo.jpg");
        this.checkContentEncoding(blob, "gzip");
        this.checkContentLanguage(blob, "en");
    }

    protected void addContentMetadata(BlobBuilder.PayloadBlobBuilder blobBuilder) {
        blobBuilder.cacheControl("max-age=3600");
        blobBuilder.contentType("text/csv");
        blobBuilder.contentDisposition("attachment; filename=photo.jpg");
        blobBuilder.contentEncoding("gzip");
        blobBuilder.contentLanguage("en");
    }

    protected void checkCacheControl(Blob blob, String cacheControl) {
        Assertions.assertThat((String)blob.getPayload().getContentMetadata().getCacheControl()).isEqualTo((Object)cacheControl);
        Assertions.assertThat((String)blob.getMetadata().getContentMetadata().getCacheControl()).isEqualTo((Object)cacheControl);
    }

    protected void checkContentType(Blob blob, String contentType) {
        assert (blob.getPayload().getContentMetadata().getContentType().startsWith(contentType)) : blob.getPayload().getContentMetadata().getContentType();
        assert (blob.getMetadata().getContentMetadata().getContentType().startsWith(contentType)) : blob.getMetadata().getContentMetadata().getContentType();
    }

    protected void checkContentDisposition(Blob blob, String contentDisposition) {
        assert (blob.getPayload().getContentMetadata().getContentDisposition().startsWith(contentDisposition)) : blob.getPayload().getContentMetadata().getContentDisposition();
        assert (blob.getMetadata().getContentMetadata().getContentDisposition().startsWith(contentDisposition)) : blob.getMetadata().getContentMetadata().getContentDisposition();
    }

    protected void checkContentEncoding(Blob blob, String contentEncoding) {
        assert (blob.getPayload().getContentMetadata().getContentEncoding().indexOf(contentEncoding) != -1) : blob.getPayload().getContentMetadata().getContentEncoding();
        assert (blob.getMetadata().getContentMetadata().getContentEncoding().indexOf(contentEncoding) != -1) : blob.getMetadata().getContentMetadata().getContentEncoding();
    }

    protected void checkContentLanguage(Blob blob, String contentLanguage) {
        assert (blob.getPayload().getContentMetadata().getContentLanguage().startsWith(contentLanguage)) : blob.getPayload().getContentMetadata().getContentLanguage();
        assert (blob.getMetadata().getContentMetadata().getContentLanguage().startsWith(contentLanguage)) : blob.getMetadata().getContentMetadata().getContentLanguage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testMetadata() throws InterruptedException, IOException {
        String name = "hello";
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder(name).userMetadata((Map)ImmutableMap.of((Object)"Adrian", (Object)"powderpuff")).payload(TEST_STRING).contentType("text/plain").contentMD5(Hashing.md5().hashString((CharSequence)TEST_STRING, Charsets.UTF_8).asBytes()).build();
        String container = this.getContainerName();
        try {
            Assert.assertNull((Object)((BlobStoreContext)this.view).getBlobStore().blobMetadata(container, "powderpuff"));
            this.addBlobToContainer(container, blob);
            Blob newObject = this.validateContent(container, name);
            MutableBlobMetadata metadata = newObject.getMetadata();
            this.validateMetadata((BlobMetadata)metadata);
            this.validateMetadata(metadata, container, name);
            this.validateMetadata(((BlobStoreContext)this.view).getBlobStore().blobMetadata(container, name));
            blob.getMetadata().getUserMetadata().put("Adrian", "wonderpuff");
            blob.getMetadata().getUserMetadata().put("Adrian", "powderpuff");
            this.awaitConsistency();
            this.addBlobToContainer(container, blob);
            this.awaitConsistency();
            this.validateMetadata(((BlobStoreContext)this.view).getBlobStore().blobMetadata(container, name));
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testCopyBlobCopyMetadata() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String fromName = "source";
        String toName = "to";
        ByteSource payload = TestUtils.randomByteSource().slice(0L, 1024L);
        ImmutableMap userMetadata = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2");
        BlobBuilder.PayloadBlobBuilder blobBuilder = blobStore.blobBuilder(fromName).payload(payload).contentLength(payload.size());
        this.addContentMetadata(blobBuilder);
        blobBuilder.userMetadata((Map)userMetadata);
        Blob blob = blobBuilder.build();
        String fromContainer = this.getContainerName();
        String toContainer = this.getContainerName();
        try {
            blobStore.putBlob(fromContainer, blob);
            blobStore.copyBlob(fromContainer, fromName, toContainer, toName, CopyOptions.NONE);
            Blob toBlob = blobStore.getBlob(toContainer, toName);
            InputStream is = null;
            try {
                is = toBlob.getPayload().openStream();
                Assert.assertEquals((byte[])ByteStreams.toByteArray((InputStream)is), (byte[])payload.read());
            }
            finally {
                Closeables2.closeQuietly((Closeable)is);
            }
            this.checkContentMetadata(toBlob);
            this.checkUserMetadata(toBlob.getMetadata().getUserMetadata(), (Map<String, String>)userMetadata);
        }
        finally {
            this.returnContainer(toContainer);
            this.returnContainer(fromContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testCopyBlobReplaceMetadata() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String fromName = "source";
        String toName = "to";
        ByteSource payload = TestUtils.randomByteSource().slice(0L, 1024L);
        BlobBuilder.PayloadBlobBuilder blobBuilder = blobStore.blobBuilder(fromName).userMetadata((Map)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2")).payload(payload).cacheControl("max-age=1800").contentLength(payload.size()).contentDisposition("attachment; filename=original.jpg").contentEncoding("compress").contentLanguage("fr").contentType("audio/ogg");
        Blob blob = blobBuilder.build();
        String fromContainer = this.getContainerName();
        String toContainer = this.getContainerName();
        try {
            blobStore.putBlob(fromContainer, blob);
            ImmutableMap userMetadata = ImmutableMap.of((Object)"key3", (Object)"value3", (Object)"key4", (Object)"value4");
            blobStore.copyBlob(fromContainer, fromName, toContainer, toName, CopyOptions.builder().contentMetadata(ContentMetadataBuilder.create().cacheControl("max-age=3600").contentType("text/csv").contentDisposition("attachment; filename=photo.jpg").contentEncoding("gzip").contentLanguage("en").build()).userMetadata((Map)userMetadata).build());
            Blob toBlob = blobStore.getBlob(toContainer, toName);
            InputStream is = null;
            try {
                is = toBlob.getPayload().openStream();
                Assert.assertEquals((byte[])ByteStreams.toByteArray((InputStream)is), (byte[])payload.read());
            }
            finally {
                Closeables2.closeQuietly((Closeable)is);
            }
            this.checkContentMetadata(toBlob);
            this.checkUserMetadata(toBlob.getMetadata().getUserMetadata(), (Map<String, String>)userMetadata);
        }
        finally {
            this.returnContainer(toContainer);
            this.returnContainer(fromContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testCopyIfMatch() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String fromName = "source";
        String toName = "to";
        ByteSource payload = TestUtils.randomByteSource().slice(0L, 1024L);
        Blob blob = blobStore.blobBuilder(fromName).payload(payload).contentLength(payload.size()).build();
        String fromContainer = this.getContainerName();
        String toContainer = this.getContainerName();
        try {
            String eTag = blobStore.putBlob(fromContainer, blob);
            blobStore.copyBlob(fromContainer, fromName, toContainer, toName, CopyOptions.builder().ifMatch(eTag).build());
            Blob toBlob = blobStore.getBlob(toContainer, toName);
            InputStream is = null;
            try {
                is = toBlob.getPayload().openStream();
                Assert.assertEquals((byte[])ByteStreams.toByteArray((InputStream)is), (byte[])payload.read());
            }
            finally {
                Closeables2.closeQuietly((Closeable)is);
            }
        }
        finally {
            this.returnContainer(toContainer);
            this.returnContainer(fromContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testCopyIfMatchNegative() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String fromName = "source";
        String toName = "to";
        ByteSource payload = TestUtils.randomByteSource().slice(0L, 1024L);
        Blob blob = blobStore.blobBuilder(fromName).payload(payload).contentLength(payload.size()).build();
        String fromContainer = this.getContainerName();
        String toContainer = this.getContainerName();
        try {
            blobStore.putBlob(fromContainer, blob);
            try {
                blobStore.copyBlob(fromContainer, fromName, toContainer, toName, CopyOptions.builder().ifMatch("fake-etag").build());
                Fail.failBecauseExceptionWasNotThrown(HttpResponseException.class);
            }
            catch (HttpResponseException hre) {
                Assertions.assertThat((int)hre.getResponse().getStatusCode()).isEqualTo(412);
            }
        }
        finally {
            this.returnContainer(toContainer);
            this.returnContainer(fromContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testCopyIfNoneMatch() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String fromName = "source";
        String toName = "to";
        ByteSource payload = TestUtils.randomByteSource().slice(0L, 1024L);
        Blob blob = blobStore.blobBuilder(fromName).payload(payload).contentLength(payload.size()).build();
        String fromContainer = this.getContainerName();
        String toContainer = this.getContainerName();
        try {
            blobStore.putBlob(fromContainer, blob);
            blobStore.copyBlob(fromContainer, fromName, toContainer, toName, CopyOptions.builder().ifNoneMatch("fake-etag").build());
            Blob toBlob = blobStore.getBlob(toContainer, toName);
            InputStream is = null;
            try {
                is = toBlob.getPayload().openStream();
                Assert.assertEquals((byte[])ByteStreams.toByteArray((InputStream)is), (byte[])payload.read());
            }
            finally {
                Closeables2.closeQuietly((Closeable)is);
            }
        }
        finally {
            this.returnContainer(toContainer);
            this.returnContainer(fromContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testCopyIfNoneMatchNegative() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String fromName = "source";
        String toName = "to";
        ByteSource payload = TestUtils.randomByteSource().slice(0L, 1024L);
        Blob blob = blobStore.blobBuilder(fromName).payload(payload).contentLength(payload.size()).build();
        String fromContainer = this.getContainerName();
        String toContainer = this.getContainerName();
        try {
            String eTag = blobStore.putBlob(fromContainer, blob);
            try {
                blobStore.copyBlob(fromContainer, fromName, toContainer, toName, CopyOptions.builder().ifNoneMatch(eTag).build());
                Fail.failBecauseExceptionWasNotThrown(HttpResponseException.class);
            }
            catch (HttpResponseException hre) {
                Assertions.assertThat((int)hre.getResponse().getStatusCode()).isEqualTo(412);
            }
        }
        finally {
            this.returnContainer(toContainer);
            this.returnContainer(fromContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testCopyIfModifiedSince() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String fromName = "source";
        String toName = "to";
        ByteSource payload = TestUtils.randomByteSource().slice(0L, 1024L);
        Blob blob = blobStore.blobBuilder(fromName).payload(payload).contentLength(payload.size()).build();
        String fromContainer = this.getContainerName();
        String toContainer = this.getContainerName();
        try {
            blobStore.putBlob(fromContainer, blob);
            Date before = new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(1L));
            blobStore.copyBlob(fromContainer, fromName, toContainer, toName, CopyOptions.builder().ifModifiedSince(before).build());
            Blob toBlob = blobStore.getBlob(toContainer, toName);
            InputStream is = null;
            try {
                is = toBlob.getPayload().openStream();
                Assert.assertEquals((byte[])ByteStreams.toByteArray((InputStream)is), (byte[])payload.read());
            }
            finally {
                Closeables2.closeQuietly((Closeable)is);
            }
        }
        finally {
            this.returnContainer(toContainer);
            this.returnContainer(fromContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testCopyIfModifiedSinceNegative() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String fromName = "source";
        String toName = "to";
        ByteSource payload = TestUtils.randomByteSource().slice(0L, 1024L);
        Blob blob = blobStore.blobBuilder(fromName).payload(payload).contentLength(payload.size()).build();
        String fromContainer = this.getContainerName();
        String toContainer = this.getContainerName();
        try {
            blobStore.putBlob(fromContainer, blob);
            Date after = new Date(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(1L));
            try {
                blobStore.copyBlob(fromContainer, fromName, toContainer, toName, CopyOptions.builder().ifModifiedSince(after).build());
                Fail.failBecauseExceptionWasNotThrown(HttpResponseException.class);
            }
            catch (HttpResponseException hre) {
                Assertions.assertThat((int)hre.getResponse().getStatusCode()).isIn(new Object[]{304, 412});
            }
        }
        finally {
            this.returnContainer(toContainer);
            this.returnContainer(fromContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testCopyIfUnmodifiedSince() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String fromName = "source";
        String toName = "to";
        ByteSource payload = TestUtils.randomByteSource().slice(0L, 1024L);
        Blob blob = blobStore.blobBuilder(fromName).payload(payload).contentLength(payload.size()).build();
        String fromContainer = this.getContainerName();
        String toContainer = this.getContainerName();
        try {
            blobStore.putBlob(fromContainer, blob);
            Date after = new Date(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(1L));
            blobStore.copyBlob(fromContainer, fromName, toContainer, toName, CopyOptions.builder().ifUnmodifiedSince(after).build());
            Blob toBlob = blobStore.getBlob(toContainer, toName);
            InputStream is = null;
            try {
                is = toBlob.getPayload().openStream();
                Assert.assertEquals((byte[])ByteStreams.toByteArray((InputStream)is), (byte[])payload.read());
            }
            finally {
                Closeables2.closeQuietly((Closeable)is);
            }
        }
        finally {
            this.returnContainer(toContainer);
            this.returnContainer(fromContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testCopyIfUnmodifiedSinceNegative() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String fromName = "source";
        String toName = "to";
        ByteSource payload = TestUtils.randomByteSource().slice(0L, 1024L);
        Blob blob = blobStore.blobBuilder(fromName).payload(payload).contentLength(payload.size()).build();
        String fromContainer = this.getContainerName();
        String toContainer = this.getContainerName();
        try {
            blobStore.putBlob(fromContainer, blob);
            Date before = new Date(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(1L));
            try {
                blobStore.copyBlob(fromContainer, fromName, toContainer, toName, CopyOptions.builder().ifUnmodifiedSince(before).build());
                Fail.failBecauseExceptionWasNotThrown(HttpResponseException.class);
            }
            catch (HttpResponseException hre) {
                Assertions.assertThat((int)hre.getResponse().getStatusCode()).isEqualTo(412);
            }
        }
        finally {
            this.returnContainer(toContainer);
            this.returnContainer(fromContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testMultipartUploadNoPartsAbort() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String container = this.getContainerName();
        try {
            String name = "blob-name";
            Blob blob = blobStore.blobBuilder(name).build();
            MultipartUpload mpu = blobStore.initiateMultipartUpload(container, (BlobMetadata)blob.getMetadata(), new PutOptions());
            List parts = blobStore.listMultipartUpload(mpu);
            Assertions.assertThat((List)parts).isEqualTo((Object)ImmutableList.of());
            blobStore.abortMultipartUpload(mpu);
            blob = blobStore.getBlob(container, name);
            Assertions.assertThat((Comparable)blob).isNull();
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testMultipartUploadSinglePart() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String container = this.getContainerName();
        try {
            String name = "blob-name";
            BlobBuilder.PayloadBlobBuilder blobBuilder = blobStore.blobBuilder(name).userMetadata((Map)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2")).payload(new byte[0]);
            this.addContentMetadata(blobBuilder);
            Blob blob = blobBuilder.build();
            MultipartUpload mpu = blobStore.initiateMultipartUpload(container, (BlobMetadata)blob.getMetadata(), new PutOptions());
            ByteSource byteSource = TestUtils.randomByteSource().slice(0L, 1L);
            ByteSourcePayload payload = Payloads.newByteSourcePayload((ByteSource)byteSource);
            payload.getContentMetadata().setContentLength(Long.valueOf(byteSource.size()));
            MultipartPart part = blobStore.uploadMultipartPart(mpu, 1, (Payload)payload);
            List parts = blobStore.listMultipartUpload(mpu);
            Assertions.assertThat((List)parts).hasSize(1);
            Assertions.assertThat((int)((MultipartPart)parts.get(0)).partNumber()).isEqualTo(part.partNumber());
            Assertions.assertThat((long)((MultipartPart)parts.get(0)).partSize()).isEqualTo(part.partSize());
            Assertions.assertThat((String)((MultipartPart)parts.get(0)).partETag()).isEqualTo((Object)part.partETag());
            blobStore.completeMultipartUpload(mpu, (List)ImmutableList.of((Object)part));
            Blob newBlob = blobStore.getBlob(container, name);
            Assertions.assertThat((Comparable)newBlob).isNotNull();
            Assertions.assertThat((byte[])ByteStreams2.toByteArrayAndClose((InputStream)newBlob.getPayload().openStream())).isEqualTo((Object)byteSource.read());
            this.checkContentMetadata(newBlob);
            this.checkUserMetadata(newBlob.getMetadata().getUserMetadata(), blob.getMetadata().getUserMetadata());
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testMultipartUploadMultipleParts() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String container = this.getContainerName();
        try {
            String name = "blob-name";
            BlobBuilder.PayloadBlobBuilder blobBuilder = blobStore.blobBuilder(name).userMetadata((Map)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2")).payload(new byte[0]);
            this.addContentMetadata(blobBuilder);
            Blob blob = blobBuilder.build();
            MultipartUpload mpu = blobStore.initiateMultipartUpload(container, (BlobMetadata)blob.getMetadata(), new PutOptions());
            ByteSource byteSource = TestUtils.randomByteSource().slice(0L, blobStore.getMinimumMultipartPartSize() + 1L);
            ByteSource byteSource1 = byteSource.slice(0L, blobStore.getMinimumMultipartPartSize());
            ByteSource byteSource2 = byteSource.slice(blobStore.getMinimumMultipartPartSize(), 1L);
            ByteSourcePayload payload1 = Payloads.newByteSourcePayload((ByteSource)byteSource1);
            ByteSourcePayload payload2 = Payloads.newByteSourcePayload((ByteSource)byteSource2);
            payload1.getContentMetadata().setContentLength(Long.valueOf(byteSource1.size()));
            payload2.getContentMetadata().setContentLength(Long.valueOf(byteSource2.size()));
            MultipartPart part1 = blobStore.uploadMultipartPart(mpu, 1, (Payload)payload1);
            MultipartPart part2 = blobStore.uploadMultipartPart(mpu, 2, (Payload)payload2);
            List parts = blobStore.listMultipartUpload(mpu);
            Assertions.assertThat((List)parts).hasSize(2);
            Assertions.assertThat((int)((MultipartPart)parts.get(0)).partNumber()).isEqualTo(part1.partNumber());
            Assertions.assertThat((long)((MultipartPart)parts.get(0)).partSize()).isEqualTo(part1.partSize());
            Assertions.assertThat((String)((MultipartPart)parts.get(0)).partETag()).isEqualTo((Object)part1.partETag());
            Assertions.assertThat((int)((MultipartPart)parts.get(1)).partNumber()).isEqualTo(part2.partNumber());
            Assertions.assertThat((long)((MultipartPart)parts.get(1)).partSize()).isEqualTo(part2.partSize());
            Assertions.assertThat((String)((MultipartPart)parts.get(1)).partETag()).isEqualTo((Object)part2.partETag());
            blobStore.completeMultipartUpload(mpu, (List)ImmutableList.of((Object)part1, (Object)part2));
            Blob newBlob = blobStore.getBlob(container, name);
            Assertions.assertThat((byte[])ByteStreams2.toByteArrayAndClose((InputStream)newBlob.getPayload().openStream())).isEqualTo((Object)byteSource.read());
            this.checkContentMetadata(newBlob);
            this.checkUserMetadata(newBlob.getMetadata().getUserMetadata(), blob.getMetadata().getUserMetadata());
        }
        finally {
            this.returnContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(groups={"integration", "live"})
    public void testListMultipartUploads() throws Exception {
        String container;
        block3: {
            BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
            String name = "blob-name";
            BlobBuilder.PayloadBlobBuilder blobBuilder = blobStore.blobBuilder(name).userMetadata((Map)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2")).payload(new byte[0]);
            this.addContentMetadata(blobBuilder);
            Blob blob = blobBuilder.build();
            MultipartUpload mpu = null;
            container = this.getContainerName();
            try {
                List uploads = blobStore.listMultipartUploads(container);
                Assertions.assertThat((List)uploads).isEmpty();
                mpu = blobStore.initiateMultipartUpload(container, (BlobMetadata)blob.getMetadata(), new PutOptions());
                Assertions.assertThat((int)uploads.size()).isBetween(Integer.valueOf(0), Integer.valueOf(1));
                ByteSource byteSource = TestUtils.randomByteSource().slice(0L, blobStore.getMinimumMultipartPartSize() + 1L);
                ByteSource byteSource1 = byteSource.slice(0L, blobStore.getMinimumMultipartPartSize());
                ByteSource byteSource2 = byteSource.slice(blobStore.getMinimumMultipartPartSize(), 1L);
                ByteSourcePayload payload1 = Payloads.newByteSourcePayload((ByteSource)byteSource1);
                ByteSourcePayload payload2 = Payloads.newByteSourcePayload((ByteSource)byteSource2);
                payload1.getContentMetadata().setContentLength(Long.valueOf(byteSource1.size()));
                payload2.getContentMetadata().setContentLength(Long.valueOf(byteSource2.size()));
                MultipartPart part1 = blobStore.uploadMultipartPart(mpu, 1, (Payload)payload1);
                MultipartPart part2 = blobStore.uploadMultipartPart(mpu, 2, (Payload)payload2);
                uploads = blobStore.listMultipartUploads(container);
                Assertions.assertThat((List)uploads).hasSize(1);
                blobStore.completeMultipartUpload(mpu, (List)ImmutableList.of((Object)part1, (Object)part2));
                mpu = null;
                uploads = blobStore.listMultipartUploads(container);
                Assertions.assertThat((List)uploads).isEmpty();
                if (mpu == null) break block3;
            }
            catch (Throwable throwable) {
                if (mpu != null) {
                    blobStore.abortMultipartUpload(mpu);
                }
                this.returnContainer(container);
                throw throwable;
            }
            blobStore.abortMultipartUpload(mpu);
        }
        this.returnContainer(container);
    }

    @Test(groups={"integration", "live"}, expectedExceptions={KeyNotFoundException.class})
    public void testCopy404BlobFail() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String container = this.getContainerName();
        try {
            blobStore.copyBlob(container, "blob", container, "blob2", CopyOptions.NONE);
        }
        finally {
            this.returnContainer(container);
        }
    }

    @Test(groups={"integration", "live"}, expectedExceptions={KeyNotFoundException.class})
    public void testCopy404BlobMetaFail() throws Exception {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String container = this.getContainerName();
        try {
            blobStore.copyBlob(container, "blob", container, "blob2", CopyOptions.builder().userMetadata((Map)ImmutableMap.of((Object)"x", (Object)"1")).build());
        }
        finally {
            this.returnContainer(container);
        }
    }

    protected void validateMetadata(BlobMetadata metadata) throws IOException {
        assert (metadata.getContentMetadata().getContentType().startsWith("text/plain")) : metadata.getContentMetadata().getContentType();
        Assert.assertEquals((Object)metadata.getContentMetadata().getContentLength(), (Object)TEST_STRING.length());
        Assert.assertEquals((String)((String)metadata.getUserMetadata().get("adrian")), (String)"powderpuff");
        this.checkMD5(metadata);
    }

    protected void checkMD5(BlobMetadata metadata) throws IOException {
        Assert.assertEquals((byte[])metadata.getContentMetadata().getContentMD5(), (byte[])Hashing.md5().hashString((CharSequence)TEST_STRING, Charsets.UTF_8).asBytes());
    }

    private static ByteSource createTestInput(int length) {
        return TestUtils.randomByteSource().slice(0L, (long)new Random().nextInt(length));
    }

    static {
        try {
            crypto = new JCECrypto();
        }
        catch (NoSuchAlgorithmException e) {
            Throwables.propagate((Throwable)e);
        }
        catch (CertificateException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

