/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.internal.BlobRuntimeException;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ClearContainerStrategy;
import org.jclouds.blobstore.strategy.ClearListStrategy;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.logging.Logger;

@Singleton
public class DeleteAllKeysInList
implements ClearListStrategy,
ClearContainerStrategy {
    @Resource
    @Named(value="jclouds.blobstore")
    protected Logger logger = Logger.NULL;
    protected final BackoffLimitedRetryHandler retryHandler;
    private final ListeningExecutorService executorService;
    protected final BlobStore blobStore;
    protected long maxTime = Long.MAX_VALUE;
    protected int maxErrors = 3;

    @Inject
    DeleteAllKeysInList(@Named(value="jclouds.user-threads") ListeningExecutorService executorService, BlobStore blobStore, BackoffLimitedRetryHandler retryHandler) {
        this.executorService = executorService;
        this.blobStore = blobStore;
        this.retryHandler = retryHandler;
    }

    @Inject(optional=true)
    void setMaxTime(@Named(value="jclouds.request-timeout") long maxTime) {
        this.maxTime = maxTime;
    }

    @Inject(optional=true)
    void setMaxErrors(@Named(value="jclouds.max-retries") int maxErrors) {
        this.maxErrors = maxErrors;
    }

    @Override
    public void execute(String containerName) {
        this.execute(containerName, ListContainerOptions.Builder.recursive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final String containerName, ListContainerOptions options) {
        String message = options.getDir() != null ? String.format("clearing path %s/%s", containerName, options.getDir()) : String.format("clearing container %s", containerName);
        if ((options = options.clone()).isRecursive()) {
            message = message + " recursively";
        }
        this.logger.debug(message, new Object[0]);
        Map exceptions = Maps.newHashMap();
        int numErrors = 0;
        while (numErrors < this.maxErrors) {
            PageSet<? extends StorageMetadata> listing = this.blobStore.list(containerName, options);
            if (options.isRecursive()) {
                for (StorageMetadata storageMetadata : listing) {
                    String string = this.parentIsFolder(options, storageMetadata) ? options.getDir() + "/" + storageMetadata.getName() : storageMetadata.getName();
                    switch (storageMetadata.getType()) {
                        case BLOB: {
                            break;
                        }
                        case FOLDER: 
                        case RELATIVE_PATH: {
                            if (!options.isRecursive() || string.equals(options.getDir())) break;
                            this.execute(containerName, options.clone().inDirectory(string));
                            break;
                        }
                        case CONTAINER: {
                            throw new IllegalArgumentException("Container type not supported");
                        }
                    }
                }
            }
            HashMap responses = Maps.newHashMap();
            for (final StorageMetadata storageMetadata : listing) {
                final String fullPath = this.parentIsFolder(options, storageMetadata) ? options.getDir() + "/" + storageMetadata.getName() : storageMetadata.getName();
                switch (storageMetadata.getType()) {
                    case BLOB: {
                        responses.put(storageMetadata, this.executorService.submit(new Runnable(){

                            @Override
                            public void run() {
                                DeleteAllKeysInList.this.blobStore.removeBlob(containerName, fullPath);
                            }
                        }));
                        break;
                    }
                    case FOLDER: {
                        if (!options.isRecursive()) break;
                        responses.put(storageMetadata, this.executorService.submit(new Runnable(){

                            @Override
                            public void run() {
                                DeleteAllKeysInList.this.blobStore.deleteDirectory(containerName, fullPath);
                            }
                        }));
                        break;
                    }
                    case RELATIVE_PATH: {
                        if (!options.isRecursive()) break;
                        responses.put(storageMetadata, this.executorService.submit(new Runnable(){

                            @Override
                            public void run() {
                                DeleteAllKeysInList.this.blobStore.deleteDirectory(containerName, storageMetadata.getName());
                            }
                        }));
                        break;
                    }
                    case CONTAINER: {
                        throw new IllegalArgumentException("Container type not supported");
                    }
                }
            }
            try {
                exceptions = FutureIterables.awaitCompletion((Map)responses, (ListeningExecutorService)this.executorService, (Long)this.maxTime, (Logger)this.logger, (String)message);
            }
            catch (TimeoutException timeoutException) {
                if (++numErrors == this.maxErrors) {
                    throw Throwables.propagate((Throwable)timeoutException);
                }
                this.retryHandler.imposeBackoffExponentialDelay(numErrors, message);
            }
            finally {
                for (ListenableFuture future : responses.values()) {
                    future.cancel(true);
                }
                continue;
            }
            if (!exceptions.isEmpty()) {
                if (++numErrors == this.maxErrors) break;
                this.retryHandler.imposeBackoffExponentialDelay(numErrors, message);
                continue;
            }
            String string = listing.getNextMarker();
            if (string == null) break;
            this.logger.debug("%s with marker %s", new Object[]{message, string});
            options = options.afterMarker(string);
            numErrors = 0;
        }
        if (!exceptions.isEmpty()) {
            throw new BlobRuntimeException(String.format("error %s: %s", message, exceptions));
        }
    }

    private boolean parentIsFolder(ListContainerOptions options, StorageMetadata md) {
        return options.getDir() != null && md.getName().indexOf(47) == -1;
    }
}

