/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.TreeSet;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.s3.blobstore.functions.CommonPrefixesToResourceMetadata;
import org.jclouds.s3.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.s3.domain.ListBucketResponse;

@Singleton
public class BucketToResourceList
implements Function<ListBucketResponse, PageSet<? extends StorageMetadata>> {
    private final ObjectToBlobMetadata object2blobMd;
    private final CommonPrefixesToResourceMetadata prefix2ResourceMd;
    protected final Function<StorageMetadata, String> indexer = new Function<StorageMetadata, String>(){

        public String apply(StorageMetadata from) {
            return from.getName();
        }
    };

    @Inject
    public BucketToResourceList(ObjectToBlobMetadata object2blobMd, CommonPrefixesToResourceMetadata prefix2ResourceMd) {
        this.object2blobMd = object2blobMd;
        this.prefix2ResourceMd = prefix2ResourceMd;
    }

    public PageSet<? extends StorageMetadata> apply(ListBucketResponse from) {
        TreeSet contents = Sets.newTreeSet((Iterable)Iterables.transform((Iterable)from, (Function)this.object2blobMd));
        for (String prefix : from.getCommonPrefixes()) {
            contents.add(this.prefix2ResourceMd.apply(prefix));
        }
        return new PageSetImpl((Iterable)contents, from.getNextMarker());
    }
}

