/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.base.Throwables;
import jakarta.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;
import org.jclouds.s3.binders.BindBucketLoggingToXmlPayload;
import org.jclouds.s3.binders.XMLHelper;
import org.jclouds.s3.domain.AccessControlList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class BindACLToXMLPayload
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        AccessControlList from = (AccessControlList)payload;
        try {
            request.setPayload(this.generatePayload(from));
            request.getPayload().getContentMetadata().setContentType("text/xml");
            return request;
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new RuntimeException("error transforming acl: " + from, e);
        }
    }

    protected String generatePayload(AccessControlList acl) throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        Document document = XMLHelper.createDocument();
        Element rootNode = XMLHelper.elem(document, "AccessControlPolicy", document);
        rootNode.setAttribute("xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        if (acl.getOwner() != null) {
            Element ownerNode = XMLHelper.elem(rootNode, "Owner", document);
            XMLHelper.elemWithText(ownerNode, "ID", acl.getOwner().getId(), document);
            String displayName = acl.getOwner().getDisplayName();
            if (displayName != null) {
                XMLHelper.elemWithText(ownerNode, "DisplayName", displayName, document);
            }
        }
        BindBucketLoggingToXmlPayload.addGrants(XMLHelper.elem(rootNode, "AccessControlList", document), acl.getGrants(), document);
        return XMLHelper.asString(document);
    }
}

