/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.xml;

import org.jclouds.http.HttpException;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.s3.domain.Payer;
import org.jclouds.s3.xml.PayerHandler;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="PayerHandlerTest")
public class PayerHandlerTest
extends BaseHandlerTest {
    ParseSax<Payer> createParser() {
        ParseSax parser = this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(PayerHandler.class));
        return parser;
    }

    @Test
    public void testPayerRequester() throws HttpException {
        Payer payer = (Payer)this.createParser().parse(Strings2.toInputStream((String)"<RequestPaymentConfiguration xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Payer>Requester</Payer></RequestPaymentConfiguration>"));
        Assert.assertEquals((Object)payer, (Object)Payer.REQUESTER);
    }

    @Test
    public void testPayerBucketOwner() throws HttpException {
        Payer payer = (Payer)this.createParser().parse(Strings2.toInputStream((String)"<RequestPaymentConfiguration xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Payer>BucketOwner</Payer></RequestPaymentConfiguration>"));
        Assert.assertEquals((Object)payer, (Object)Payer.BUCKET_OWNER);
    }
}

