/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.jclouds.http.options.HttpRequestOptions;
import org.jclouds.s3.options.ListBucketOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ListBucketOptionsTest {
    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(ListBucketOptions.class));
        assert (!String.class.isAssignableFrom(ListBucketOptions.class));
    }

    @Test
    public void testPrefix() {
        ListBucketOptions options = new ListBucketOptions();
        options.withPrefix("test");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"prefix"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNoOptionsQueryString() {
        ListBucketOptions options = new ListBucketOptions();
        Assert.assertEquals((int)options.buildQueryParameters().size(), (int)0);
    }

    @Test
    public void testOneOptionQueryString() {
        ListBucketOptions options = new ListBucketOptions();
        options.withPrefix("test");
        Multimap map = options.buildQueryParameters();
        Assert.assertEquals((int)map.size(), (int)1);
        Assert.assertEquals((Collection)map.get((Object)"prefix"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testTwoOptionQueryString() {
        ListBucketOptions options = new ListBucketOptions();
        options.withPrefix("test").maxResults(1);
        Multimap map = options.buildQueryParameters();
        Assert.assertEquals((int)map.size(), (int)2);
        Assert.assertEquals((Collection)map.get((Object)"prefix"), (Collection)ImmutableList.of((Object)"test"));
        Assert.assertEquals((Collection)map.get((Object)"max-keys"), (Collection)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testPrefixAndDelimiterUrlEncodingQueryString() {
        ListBucketOptions options = new ListBucketOptions();
        options.withPrefix("/test").delimiter("/");
        Multimap map = options.buildQueryParameters();
        Assert.assertEquals((int)map.size(), (int)2);
        Assert.assertEquals((Collection)map.get((Object)"prefix"), (Collection)ImmutableList.of((Object)"/test"));
        Assert.assertEquals((Collection)map.get((Object)"delimiter"), (Collection)ImmutableList.of((Object)"/"));
    }

    @Test
    public void testNullPrefix() {
        ListBucketOptions options = new ListBucketOptions();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"prefix"), (Collection)ImmutableList.of());
    }

    @Test
    public void testPrefixStatic() {
        ListBucketOptions options = ListBucketOptions.Builder.withPrefix((String)"test");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"prefix"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testPrefixNPE() {
        ListBucketOptions.Builder.withPrefix(null);
    }

    @Test
    public void testMarker() {
        ListBucketOptions options = new ListBucketOptions();
        options.afterMarker("test");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"marker"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullMarker() {
        ListBucketOptions options = new ListBucketOptions();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"marker"), (Collection)ImmutableList.of());
    }

    @Test
    public void testMarkerStatic() {
        ListBucketOptions options = ListBucketOptions.Builder.afterMarker((String)"test");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"marker"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testMarkerNPE() {
        ListBucketOptions.Builder.afterMarker(null);
    }

    @Test
    public void testMaxKeys() {
        ListBucketOptions options = new ListBucketOptions();
        options.maxResults(1000);
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"max-keys"), (Collection)ImmutableList.of((Object)"1000"));
    }

    @Test
    public void testNullMaxKeys() {
        ListBucketOptions options = new ListBucketOptions();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"max-keys"), (Collection)ImmutableList.of());
    }

    @Test
    public void testMaxKeysStatic() {
        ListBucketOptions options = ListBucketOptions.Builder.maxResults((int)1000);
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"max-keys"), (Collection)ImmutableList.of((Object)"1000"));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testMaxKeysNegative() {
        ListBucketOptions.Builder.maxResults((int)-1);
    }

    @Test
    public void testDelimiter() {
        ListBucketOptions options = new ListBucketOptions();
        options.delimiter("test");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"delimiter"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullDelimiter() {
        ListBucketOptions options = new ListBucketOptions();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"delimiter"), (Collection)ImmutableList.of());
    }

    @Test
    public void testDelimiterStatic() {
        ListBucketOptions options = ListBucketOptions.Builder.delimiter((String)"test");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"delimiter"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testDelimiterNPE() {
        ListBucketOptions.Builder.delimiter(null);
    }
}

