/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.options;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Date;
import java.util.Map;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.s3.domain.CannedAccessPolicy;
import org.jclouds.s3.options.CopyObjectOptions;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CopyObjectOptionsTest {
    private String etag;
    private Date now;
    private String nowExpected;
    private Map<String, String> goodMeta;

    @BeforeTest
    void setUp() {
        this.goodMeta = ImmutableMap.of((Object)"x-amz-meta-adrian", (Object)"foo");
        Date date = new Date();
        this.nowExpected = new SimpleDateFormatDateService().rfc822DateFormat(date);
        this.now = new SimpleDateFormatDateService().rfc822DateParse(this.nowExpected);
        this.etag = "mama";
    }

    @Test
    void testGoodMetaStatic() {
        CopyObjectOptions options = CopyObjectOptions.Builder.overrideMetadataWith(this.goodMeta);
        options.setMetadataPrefix("x-amz-meta-");
        options.setHeaderTag("amz");
        this.assertGoodMeta(options);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testMetaNPE() {
        CopyObjectOptions.Builder.overrideMetadataWith(null);
    }

    private void assertGoodMeta(CopyObjectOptions options) {
        assert (options != null);
        assert (options.getMetadata() != null);
        Multimap headers = options.buildRequestHeaders();
        Assert.assertEquals((int)headers.size(), (int)2);
        Assert.assertEquals((String)((String)headers.get((Object)"x-amz-metadata-directive").iterator().next()), (String)"REPLACE");
        Assert.assertEquals((int)options.getMetadata().size(), (int)1);
        Assert.assertEquals((String)((String)headers.get((Object)"x-amz-meta-adrian").iterator().next()), (String)"foo");
        Assert.assertEquals((String)((String)options.getMetadata().get("x-amz-meta-adrian")), (String)"foo");
    }

    @Test
    void testGoodMeta() {
        CopyObjectOptions options = new CopyObjectOptions();
        options.setHeaderTag("amz");
        options.setMetadataPrefix("x-amz-meta-");
        options.overrideMetadataWith(this.goodMeta);
        this.assertGoodMeta(options);
    }

    @Test
    public void testIfModifiedSince() {
        CopyObjectOptions options = new CopyObjectOptions();
        options.ifSourceModifiedSince(this.now);
        Assert.assertEquals((String)options.getIfModifiedSince(), (String)this.nowExpected);
    }

    @Test
    public void testNullIfModifiedSince() {
        CopyObjectOptions options = new CopyObjectOptions();
        Assert.assertNull((Object)options.getIfModifiedSince());
    }

    @Test
    public void testIfModifiedSinceStatic() {
        CopyObjectOptions options = CopyObjectOptions.Builder.ifSourceModifiedSince((Date)this.now);
        Assert.assertEquals((String)options.getIfModifiedSince(), (String)this.nowExpected);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testIfModifiedSinceNPE() {
        CopyObjectOptions.Builder.ifSourceModifiedSince(null);
    }

    @Test
    public void testIfUnmodifiedSince() {
        CopyObjectOptions options = new CopyObjectOptions();
        options.ifSourceUnmodifiedSince(this.now);
        this.isNowExpected(options);
    }

    @Test
    public void testNullIfUnmodifiedSince() {
        CopyObjectOptions options = new CopyObjectOptions();
        Assert.assertNull((Object)options.getIfUnmodifiedSince());
    }

    @Test
    public void testIfUnmodifiedSinceStatic() {
        CopyObjectOptions options = CopyObjectOptions.Builder.ifSourceUnmodifiedSince((Date)this.now);
        this.isNowExpected(options);
    }

    private void isNowExpected(CopyObjectOptions options) {
        Assert.assertEquals((String)options.getIfUnmodifiedSince(), (String)this.nowExpected);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testIfUnmodifiedSinceNPE() {
        CopyObjectOptions.Builder.ifSourceUnmodifiedSince(null);
    }

    @Test
    public void testIfETagMatches() {
        CopyObjectOptions options = new CopyObjectOptions();
        options.ifSourceETagMatches(this.etag);
        this.matchesHex(options.getIfMatch());
    }

    @Test
    public void testNullIfETagMatches() {
        CopyObjectOptions options = new CopyObjectOptions();
        Assert.assertNull((Object)options.getIfMatch());
    }

    @Test
    public void testIfETagMatchesStatic() {
        CopyObjectOptions options = CopyObjectOptions.Builder.ifSourceETagMatches((String)this.etag);
        this.matchesHex(options.getIfMatch());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testIfETagMatchesNPE() {
        CopyObjectOptions.Builder.ifSourceETagMatches(null);
    }

    @Test
    public void testIfETagDoesntMatch() {
        CopyObjectOptions options = new CopyObjectOptions();
        options.ifSourceETagDoesntMatch(this.etag);
        this.matchesHex(options.getIfNoneMatch());
    }

    @Test
    public void testNullIfETagDoesntMatch() {
        CopyObjectOptions options = new CopyObjectOptions();
        Assert.assertNull((Object)options.getIfNoneMatch());
    }

    @Test
    public void testIfETagDoesntMatchStatic() {
        CopyObjectOptions options = CopyObjectOptions.Builder.ifSourceETagDoesntMatch((String)this.etag);
        this.matchesHex(options.getIfNoneMatch());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testIfETagDoesntMatchNPE() {
        CopyObjectOptions.Builder.ifSourceETagDoesntMatch(null);
    }

    private void matchesHex(String match) {
        String expected = "\"" + this.etag + "\"";
        Assert.assertEquals((String)match, (String)expected);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testIfUnmodifiedAfterModified() {
        CopyObjectOptions.Builder.ifSourceModifiedSince((Date)this.now).ifSourceUnmodifiedSince(this.now);
    }

    public void testIfUnmodifiedAfterETagMatches() {
        CopyObjectOptions.Builder.ifSourceETagMatches((String)this.etag).ifSourceUnmodifiedSince(this.now);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testIfUnmodifiedAfterETagDoesntMatch() {
        CopyObjectOptions.Builder.ifSourceETagDoesntMatch((String)this.etag).ifSourceUnmodifiedSince(this.now);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testIfModifiedAfterUnmodified() {
        CopyObjectOptions.Builder.ifSourceUnmodifiedSince((Date)this.now).ifSourceModifiedSince(this.now);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testIfModifiedAfterETagMatches() {
        CopyObjectOptions.Builder.ifSourceETagMatches((String)this.etag).ifSourceModifiedSince(this.now);
    }

    public void testIfModifiedAfterETagDoesntMatch() {
        CopyObjectOptions.Builder.ifSourceETagDoesntMatch((String)this.etag).ifSourceModifiedSince(this.now);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testETagMatchesAfterIfModified() {
        CopyObjectOptions.Builder.ifSourceModifiedSince((Date)this.now).ifSourceETagMatches(this.etag);
    }

    public void testETagMatchesAfterIfUnmodified() {
        CopyObjectOptions.Builder.ifSourceUnmodifiedSince((Date)this.now).ifSourceETagMatches(this.etag);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testETagMatchesAfterETagDoesntMatch() {
        CopyObjectOptions.Builder.ifSourceETagDoesntMatch((String)this.etag).ifSourceETagMatches(this.etag);
    }

    public void testETagDoesntMatchAfterIfModified() {
        CopyObjectOptions.Builder.ifSourceModifiedSince((Date)this.now).ifSourceETagDoesntMatch(this.etag);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testETagDoesntMatchAfterIfUnmodified() {
        CopyObjectOptions.Builder.ifSourceUnmodifiedSince((Date)this.now).ifSourceETagDoesntMatch(this.etag);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testETagDoesntMatchAfterETagMatches() {
        CopyObjectOptions.Builder.ifSourceETagMatches((String)this.etag).ifSourceETagDoesntMatch(this.etag);
    }

    @Test
    void testBuildRequestHeadersWhenMetadataNull() {
        CopyObjectOptions options = new CopyObjectOptions();
        options.setHeaderTag("amz");
        options.setMetadataPrefix("x-amz-meta-");
        assert (options.buildRequestHeaders() != null);
    }

    @Test
    void testBuildRequestHeaders() {
        CopyObjectOptions options = CopyObjectOptions.Builder.ifSourceModifiedSince((Date)this.now).ifSourceETagDoesntMatch(this.etag).overrideMetadataWith(this.goodMeta);
        options.setHeaderTag("amz");
        options.setMetadataPrefix("x-amz-meta-");
        Multimap headers = options.buildRequestHeaders();
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)headers.get((Object)"x-amz-copy-source-if-modified-since"))), (String)new SimpleDateFormatDateService().rfc822DateFormat(this.now));
        Assert.assertEquals((String)((String)Iterables.getOnlyElement((Iterable)headers.get((Object)"x-amz-copy-source-if-none-match"))), (String)("\"" + this.etag + "\""));
        for (String value : this.goodMeta.values()) {
            Assert.assertTrue((boolean)headers.containsValue((Object)value));
        }
    }

    @Test
    public void testAclDefault() {
        CopyObjectOptions options = new CopyObjectOptions();
        Assert.assertEquals((Object)options.getAcl(), (Object)CannedAccessPolicy.PRIVATE);
    }

    @Test
    public void testAclStatic() {
        CopyObjectOptions options = CopyObjectOptions.Builder.overrideAcl((CannedAccessPolicy)CannedAccessPolicy.AUTHENTICATED_READ);
        Assert.assertEquals((Object)options.getAcl(), (Object)CannedAccessPolicy.AUTHENTICATED_READ);
    }

    @Test
    void testBuildRequestHeadersACL() {
        CopyObjectOptions options = CopyObjectOptions.Builder.overrideAcl((CannedAccessPolicy)CannedAccessPolicy.AUTHENTICATED_READ);
        options.setHeaderTag("amz");
        options.setMetadataPrefix("x-amz-meta-");
        Multimap headers = options.buildRequestHeaders();
        Assert.assertEquals((String)((String)headers.get((Object)"x-amz-acl").iterator().next()), (String)CannedAccessPolicy.AUTHENTICATED_READ.toString());
    }
}

