/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.Map;
import org.easymock.EasyMock;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.RequestSigner;
import org.jclouds.s3.domain.MutableObjectMetadata;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.internal.MutableObjectMetadataImpl;
import org.jclouds.s3.functions.ParseObjectMetadataFromHeaders;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(testName="s3.ParseObjectMetadataFromHeadersTest")
public class ParseObjectMetadataFromHeadersTest {
    String lastModified = new SimpleDateFormatDateService().rfc822DateFormat(new Date());
    Date now = new SimpleDateFormatDateService().rfc822DateParse(this.lastModified);
    Map<String, String> userMetadata = ImmutableMap.of((Object)"foo", (Object)"bar");
    ParseObjectMetadataFromHeaders parser;

    @Test
    void testNormalParsesETagIntoMD5AndMetadataHeaders() throws Exception {
        HttpResponse http = ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(400).message("boa").payload("")).addHeader("x-amz-meta-foo", new String[]{"bar"})).addHeader("Last-Modified", new String[]{this.lastModified})).addHeader("ETag", new String[]{"\"00000000000000000000000000000000\""})).addHeader("Cache-Control", new String[]{"cacheControl"})).build();
        http.getPayload().getContentMetadata().setContentLength(Long.valueOf(1025L));
        http.getPayload().getContentMetadata().setContentDisposition("contentDisposition");
        http.getPayload().getContentMetadata().setContentEncoding("encoding");
        http.getPayload().getContentMetadata().setContentType("application/octet-stream");
        MutableObjectMetadata response = this.parser.apply(http);
        HashCode hashCode = HashCode.fromBytes((byte[])new byte[16]);
        MutableObjectMetadataImpl expects = new MutableObjectMetadataImpl();
        expects.setCacheControl("cacheControl");
        expects.getContentMetadata().setContentDisposition("contentDisposition");
        expects.getContentMetadata().setContentEncoding("encoding");
        expects.getContentMetadata().setContentType("application/octet-stream");
        expects.getContentMetadata().setContentLength(Long.valueOf(1025L));
        expects.getContentMetadata().setContentMD5(hashCode);
        expects.setETag("\"abcd\"");
        expects.setKey("key");
        expects.setLastModified(this.now);
        expects.setOwner(null);
        expects.setStorageClass(ObjectMetadata.StorageClass.STANDARD);
        expects.setUserMetadata(this.userMetadata);
        Assert.assertEquals((Object)response, (Object)expects);
    }

    @Test
    void testMultipartDoesntAttemptToParseETagIntoMD5() throws Exception {
        HttpResponse http = ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(400).message("boa").payload("")).addHeader("x-amz-meta-foo", new String[]{"bar"})).addHeader("Last-Modified", new String[]{this.lastModified})).addHeader("ETag", new String[]{"\"abcd-1\""})).addHeader("Cache-Control", new String[]{"cacheControl"})).build();
        http.getPayload().getContentMetadata().setContentLength(Long.valueOf(1025L));
        http.getPayload().getContentMetadata().setContentDisposition("contentDisposition");
        http.getPayload().getContentMetadata().setContentEncoding("encoding");
        http.getPayload().getContentMetadata().setContentType("application/octet-stream");
        MutableObjectMetadata response = this.parser.apply(http);
        MutableObjectMetadataImpl expects = new MutableObjectMetadataImpl();
        expects.setCacheControl("cacheControl");
        expects.getContentMetadata().setContentDisposition("contentDisposition");
        expects.getContentMetadata().setContentEncoding("encoding");
        expects.getContentMetadata().setContentType("application/octet-stream");
        expects.getContentMetadata().setContentLength(Long.valueOf(1025L));
        expects.setETag("\"abcd-1\"");
        expects.setKey("key");
        expects.setLastModified(this.now);
        expects.setOwner(null);
        expects.setStorageClass(ObjectMetadata.StorageClass.STANDARD);
        expects.setUserMetadata(this.userMetadata);
        Assert.assertEquals((Object)response, (Object)expects);
    }

    @Test
    void testAmzEtagStillParsesToMD5AndDoesntMistakeAmzEtagForUserMetadata() throws Exception {
        HttpResponse http = ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(400).message("boa").payload("")).addHeader("x-amz-meta-foo", new String[]{"bar"})).addHeader("Last-Modified", new String[]{this.lastModified})).addHeader("x-amz-meta-object-eTag", new String[]{"\"00000000000000000000000000000000\""})).addHeader("Cache-Control", new String[]{"cacheControl"})).build();
        http.getPayload().getContentMetadata().setContentLength(Long.valueOf(1025L));
        http.getPayload().getContentMetadata().setContentDisposition("contentDisposition");
        http.getPayload().getContentMetadata().setContentEncoding("encoding");
        http.getPayload().getContentMetadata().setContentType("application/octet-stream");
        MutableObjectMetadata response = this.parser.apply(http);
        HashCode hashCode = HashCode.fromBytes((byte[])new byte[16]);
        MutableObjectMetadataImpl expects = new MutableObjectMetadataImpl();
        expects.setCacheControl("cacheControl");
        expects.getContentMetadata().setContentDisposition("contentDisposition");
        expects.getContentMetadata().setContentEncoding("encoding");
        expects.getContentMetadata().setContentMD5(hashCode);
        expects.getContentMetadata().setContentType("application/octet-stream");
        expects.getContentMetadata().setContentLength(Long.valueOf(1025L));
        expects.setETag("\"abcd\"");
        expects.setKey("key");
        expects.setLastModified(this.now);
        expects.setOwner(null);
        expects.setStorageClass(ObjectMetadata.StorageClass.STANDARD);
        expects.setUserMetadata(this.userMetadata);
        Assert.assertEquals((Object)response, (Object)expects);
    }

    @BeforeTest
    void setUp() {
        this.parser = ((ParseObjectMetadataFromHeaders)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(RequestSigner.class).toInstance(EasyMock.createMock(RequestSigner.class));
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.aws.header.tag")).to("amz");
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"jclouds.blobstore.metaprefix")).to("x-amz-meta-");
            }
        }}).getInstance(ParseObjectMetadataFromHeaders.class)).setKey("key");
    }
}

