/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.easymock.EasyMock;
import org.jclouds.s3.functions.AssignCorrectHostnameForBucket;
import org.jclouds.s3.functions.AssignCorrectHostnameForBucketTest;
import org.jclouds.s3.functions.DefaultEndpointThenInvalidateRegion;
import org.testng.annotations.Test;

public class DefaultEndpointThenInvalidateRegionTest {
    @Test
    public void testInvalidate() throws Exception {
        LoadingCache bucketToRegionCache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        bucketToRegionCache.invalidate((Object)"mybucket");
        EasyMock.replay((Object[])new Object[]{bucketToRegionCache});
        AssignCorrectHostnameForBucket delegate = new AssignCorrectHostnameForBucket(AssignCorrectHostnameForBucketTest.REGION_TO_ENDPOINT, Functions.forMap((Map)ImmutableMap.of((Object)"mybucket", (Object)Optional.of((Object)"us-west-1"))));
        new DefaultEndpointThenInvalidateRegion(delegate, bucketToRegionCache).apply((Object)"mybucket");
        EasyMock.verify((Object[])new Object[]{bucketToRegionCache});
    }
}

