/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.filters;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.reflect.Invokable;
import com.google.inject.Injector;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import javax.inject.Named;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.logging.config.NullLoggingModule;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.internal.BaseRestApiTest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.s3.S3ApiMetadata;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.config.S3HttpApiModule;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.filters.ChunkedUploadPayload;
import org.jclouds.s3.filters.RequestAuthorizeSignatureV4;
import org.jclouds.s3.options.PutObjectOptions;
import org.jclouds.util.Closeables2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RequestAuthorizeSignatureV4ChunkedUploadTest")
public class RequestAuthorizeSignatureV4ChunkedUploadTest {
    private static final String CONTENT_SEED = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc tortor metus, sagittis eget augue ut,\nfeugiat vehicula risus. Integer tortor mauris, vehicula nec mollis et, consectetur eget tortor. In ut\nelit sagittis, ultrices est ut, iaculis turpis. In hac habitasse platea dictumst. Donec laoreet tellus\nat auctor tempus. Praesent nec diam sed urna sollicitudin vehicula eget id est. Vivamus sed laoreet\nlectus. Aliquam convallis condimentum risus, vitae porta justo venenatis vitae. Phasellus vitae nunc\nvarius, volutpat quam nec, mollis urna. Donec tempus, nisi vitae gravida facilisis, sapien sem malesuada\npurus, id semper libero ipsum condimentum nulla. Suspendisse vel mi leo. Morbi pellentesque placerat congue.\nNunc sollicitudin nunc diam, nec hendrerit dui commodo sed. Duis dapibus commodo elit, id commodo erat\ncongue id. Aliquam erat volutpat.\n";
    private static final String CHUKED_UPLOAD_PAYLOAD_SHA256 = "2b6da230b03189254b2ceafe689c5298cfdd288869e80b2b9369da8f8f0a3d99";
    private static final String PUT_OBJECT_AUTHORIZATION = "AWS4-HMAC-SHA256 Credential=AKIAPAEBI3QI4EXAMPLE/20150203/cn-north-1/s3/aws4_request, SignedHeaders=content-encoding;content-length;content-type;host;x-amz-content-sha256;x-amz-date;x-amz-decoded-content-length;x-amz-storage-class, Signature=3db48b3d786d599e8e785ba66030e8a9249c678a52f2432bf6fd44c97cb3145f";
    private static final String IDENTITY = "AKIAPAEBI3QI4EXAMPLE";
    private static final String CREDENTIAL = "oHkkcPcOjJnoAXpjT8GXdNeBjo6Ru7QeFExAmPlE";
    private static final String TIMESTAMP = "Thu, 03 Feb 2015 07:11:11 GMT";
    private static final String BUCKET_NAME = "test-bucket";
    private static final String OBJECT_NAME = "ExampleChunkedObject.txt";
    Credentials temporaryCredentials = new Credentials.Builder().identity("AKIAPAEBI3QI4EXAMPLE").credential("oHkkcPcOjJnoAXpjT8GXdNeBjo6Ru7QeFExAmPlE").build();

    public static Injector injector(Credentials creds) {
        return ContextBuilder.newBuilder((ApiMetadata)new S3ApiMetadata()).credentialsSupplier(Suppliers.ofInstance((Object)creds)).modules((Iterable)ImmutableList.of((Object)new BaseRestApiTest.MockModule(), (Object)new NullLoggingModule(), (Object)((Object)new TestS3HttpApiModule()))).buildInjector();
    }

    public static RequestAuthorizeSignatureV4 filter(Credentials creds) {
        return (RequestAuthorizeSignatureV4)RequestAuthorizeSignatureV4ChunkedUploadTest.injector(creds).getInstance(RequestAuthorizeSignatureV4.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testPutObjectWithChunkedUpload() {
        Invocation invocation = Invocation.create((Invokable)Reflection2.method(S3Client.class, (String)"putObject", (Class[])new Class[]{String.class, S3Object.class, PutObjectOptions[].class}), (List)ImmutableList.of((Object)BUCKET_NAME));
        byte[] content = RequestAuthorizeSignatureV4ChunkedUploadTest.make65KPayload().getBytes(Charset.forName("UTF-8"));
        GeneratedHttpRequest putObject = ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().invocation(invocation).method("PUT")).endpoint("https://test-bucket.s3.cn-north-1.amazonaws.com.cn/ExampleChunkedObject.txt")).addHeader("Host", new String[]{"test-bucket.s3.cn-north-1.amazonaws.com.cn"})).addHeader("x-amz-storage-class", new String[]{"REDUCED_REDUNDANCY"})).build();
        InputStreamPayload payload = Payloads.newInputStreamPayload((InputStream)new ByteArrayInputStream(content));
        payload.getContentMetadata().setContentLength(Long.valueOf(content.length));
        payload.getContentMetadata().setContentType("text/plain");
        putObject.setPayload((Payload)payload);
        HttpRequest filtered = RequestAuthorizeSignatureV4ChunkedUploadTest.filter(this.temporaryCredentials).filter((HttpRequest)putObject);
        Assert.assertEquals((String)filtered.getFirstHeaderOrNull("Authorization"), (String)PUT_OBJECT_AUTHORIZATION);
        Assert.assertEquals(filtered.getPayload().getClass(), ChunkedUploadPayload.class);
        InputStream is = null;
        try {
            is = filtered.getPayload().openStream();
            Assert.assertEquals((String)BaseEncoding.base16().lowerCase().encode(RequestAuthorizeSignatureV4ChunkedUploadTest.hash(is)), (String)CHUKED_UPLOAD_PAYLOAD_SHA256);
        }
        catch (IOException e) {
            Assert.fail((String)"open stream error", (Throwable)e);
        }
        finally {
            Closeables2.closeQuietly((Closeable)is);
        }
    }

    private static String make65KPayload() {
        StringBuilder oneKSeed = new StringBuilder();
        while (oneKSeed.length() < 1024) {
            oneKSeed.append(CONTENT_SEED);
        }
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < 66; ++i) {
            output.append((CharSequence)oneKSeed);
        }
        return output.toString();
    }

    private static byte[] hash(InputStream input) {
        try {
            int r;
            Hasher hasher = Hashing.sha256().newHasher();
            byte[] buffer = new byte[4096];
            while ((r = input.read(buffer)) != -1) {
                hasher.putBytes(buffer, 0, r);
            }
            return hasher.hash().asBytes();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    @ConfiguresHttpApi
    private static final class TestS3HttpApiModule
    extends S3HttpApiModule<S3Client> {
        private TestS3HttpApiModule() {
        }

        protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
            return RequestAuthorizeSignatureV4ChunkedUploadTest.TIMESTAMP;
        }

        protected Supplier<Date> provideTimeStampCacheDate(@Named(value="jclouds.session-interval") long seconds, @TimeStamp Supplier<String> timestamp, DateService dateService) {
            return Suppliers.ofInstance((Object)dateService.rfc822DateParse(RequestAuthorizeSignatureV4ChunkedUploadTest.TIMESTAMP));
        }
    }
}

