/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.internal;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.TimeoutException;
import org.easymock.EasyMock;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.blobstore.internal.BackoffOnNotFoundWhenGetBucketACL;
import org.jclouds.s3.domain.AccessControlList;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="BackoffOnNotFoundWhenGetBucketACLTest")
public class BackoffOnNotFoundWhenGetBucketACLTest {
    private S3Client mock;

    @BeforeMethod
    public void setUp() {
        this.mock = (S3Client)EasyMock.createMock(S3Client.class);
    }

    @Test
    void testMaxRetriesNotExceededReturnsValue() {
        AccessControlList acl = (AccessControlList)EasyMock.createMock(AccessControlList.class);
        int attempts = 5;
        BackoffOnNotFoundWhenGetBucketACL backoff = new BackoffOnNotFoundWhenGetBucketACL(this.mock);
        EasyMock.expect((Object)this.mock.getBucketACL("foo")).andThrow((Throwable)new ResourceNotFoundException()).times(attempts - 1);
        EasyMock.expect((Object)this.mock.getBucketACL("foo")).andReturn((Object)acl);
        EasyMock.replay((Object[])new Object[]{this.mock});
        Assert.assertSame((Object)backoff.load("foo"), (Object)acl);
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    void testMaxRetriesExceededThrowsException() {
        int attempts = 5;
        BackoffOnNotFoundWhenGetBucketACL backoff = new BackoffOnNotFoundWhenGetBucketACL(this.mock);
        EasyMock.expect((Object)this.mock.getBucketACL("foo")).andThrow((Throwable)new ResourceNotFoundException()).times(attempts);
        EasyMock.replay((Object[])new Object[]{this.mock});
        backoff.load("foo");
    }

    @Test(expectedExceptions={UncheckedExecutionException.class})
    void testDoesntCatchOtherExceptions() {
        BackoffOnNotFoundWhenGetBucketACL backoff = new BackoffOnNotFoundWhenGetBucketACL(this.mock);
        EasyMock.expect((Object)this.mock.getBucketACL("foo")).andThrow((Throwable)new UncheckedExecutionException((Throwable)new TimeoutException()));
        EasyMock.replay((Object[])new Object[]{this.mock});
        backoff.load("foo");
        EasyMock.verify((Object[])new Object[]{this.mock});
    }
}

