/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.net.URI;
import java.util.Map;
import org.jclouds.blobstore.binders.BindMapToHeadersWithPrefix;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.binders.BindS3ObjectMetadataToRequest;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.internal.BaseS3ClientTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindS3ObjectMetadataToRequestTest")
public class BindS3ObjectMetadataToRequestTest
extends BaseS3ClientTest<S3Client> {
    @Test
    public void testPassWithMinimumDetailsAndPayload5GB() {
        S3Object object = ((S3Object.Factory)this.injector.getInstance(S3Object.Factory.class)).create(null);
        StringPayload payload = Payloads.newStringPayload((String)"");
        payload.getContentMetadata().setContentLength(Long.valueOf(0x140000000L));
        object.setPayload((Payload)payload);
        object.getMetadata().setKey("foo");
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint("http://localhost").build();
        BindS3ObjectMetadataToRequest binder = (BindS3ObjectMetadataToRequest)this.injector.getInstance(BindS3ObjectMetadataToRequest.class);
        Assert.assertEquals((Object)binder.bindToRequest(request, (Object)object), (Object)HttpRequest.builder().method("PUT").endpoint(URI.create("http://localhost")).build());
    }

    @Test
    public void testExtendedPropertiesBind() {
        S3Object object = ((S3Object.Factory)this.injector.getInstance(S3Object.Factory.class)).create(null);
        StringPayload payload = Payloads.newStringPayload((String)"");
        payload.getContentMetadata().setContentLength(Long.valueOf(0x140000000L));
        object.setPayload((Payload)payload);
        object.getMetadata().setKey("foo");
        object.getMetadata().setUserMetadata((Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint("http://localhost").build();
        BindS3ObjectMetadataToRequest binder = (BindS3ObjectMetadataToRequest)this.injector.getInstance(BindS3ObjectMetadataToRequest.class);
        Assert.assertEquals((Object)binder.bindToRequest(request, (Object)object), (Object)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint(URI.create("http://localhost")).headers((Multimap)ImmutableMultimap.of((Object)"x-amz-meta-foo", (Object)"bar"))).build());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNoContentLengthIsBad() {
        S3Object object = ((S3Object.Factory)this.injector.getInstance(S3Object.Factory.class)).create(null);
        StringPayload payload = Payloads.newStringPayload((String)"");
        payload.getContentMetadata().setContentLength(null);
        object.setPayload((Payload)payload);
        object.getMetadata().setKey("foo");
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint("http://localhost").build();
        BindS3ObjectMetadataToRequest binder = (BindS3ObjectMetadataToRequest)this.injector.getInstance(BindS3ObjectMetadataToRequest.class);
        binder.bindToRequest(request, (Object)object);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNoKeyIsBad() {
        S3Object object = ((S3Object.Factory)this.injector.getInstance(S3Object.Factory.class)).create(null);
        StringPayload payload = Payloads.newStringPayload((String)"");
        payload.getContentMetadata().setContentLength(Long.valueOf(5368709120000L));
        object.setPayload((Payload)payload);
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint("http://localhost").build();
        BindS3ObjectMetadataToRequest binder = (BindS3ObjectMetadataToRequest)this.injector.getInstance(BindS3ObjectMetadataToRequest.class);
        binder.bindToRequest(request, (Object)object);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testOver5GBIsBad() {
        S3Object object = ((S3Object.Factory)this.injector.getInstance(S3Object.Factory.class)).create(null);
        StringPayload payload = Payloads.newStringPayload((String)"");
        payload.getContentMetadata().setContentLength(Long.valueOf(5368709120000L));
        object.setPayload((Payload)payload);
        object.getMetadata().setKey("foo");
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint("http://localhost").build();
        BindS3ObjectMetadataToRequest binder = (BindS3ObjectMetadataToRequest)this.injector.getInstance(BindS3ObjectMetadataToRequest.class);
        binder.bindToRequest(request, (Object)object);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeS3Object() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        ((BindS3ObjectMetadataToRequest)this.injector.getInstance(BindS3ObjectMetadataToRequest.class)).bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        BindMapToHeadersWithPrefix binder = new BindMapToHeadersWithPrefix("prefix:");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        binder.bindToRequest(request, null);
    }
}

