/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.collect.ImmutableMap;
import org.jclouds.blobstore.binders.BindMapToHeadersWithPrefix;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.s3.binders.BindPartIdsAndETagsToRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindPartIdsAndETagsToRequestTest")
public class BindPartIdsAndETagsToRequestTest {
    BindPartIdsAndETagsToRequest binder = new BindPartIdsAndETagsToRequest();

    @Test
    public void testPassWithMinimumDetailsAndPayload5GB() {
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint("http://localhost").build();
        StringPayload payload = Payloads.newStringPayload((String)"<CompleteMultipartUpload><Part><PartNumber>1</PartNumber><ETag>\"a54357aff0632cce46d942af68356b38\"</ETag></Part></CompleteMultipartUpload>");
        payload.getContentMetadata().setContentType("text/xml");
        request = this.binder.bindToRequest(request, (Object)ImmutableMap.of((Object)1, (Object)"\"a54357aff0632cce46d942af68356b38\""));
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)payload.getRawContent());
        Assert.assertEquals((Object)request, (Object)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("http://localhost").payload((Payload)payload)).build());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testEmptyIsBad() {
        HttpRequest request = HttpRequest.builder().method("PUT").endpoint("http://localhost").build();
        this.binder.bindToRequest(request, (Object)ImmutableMap.of());
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        BindMapToHeadersWithPrefix binder = new BindMapToHeadersWithPrefix("prefix:");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        binder.bindToRequest(request, null);
    }
}

