/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.jclouds.http.HttpRequest;
import org.jclouds.reflect.Reflection2;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.binders.BindAsHostPrefixIfConfigured;
import org.jclouds.s3.internal.BaseS3ClientTest;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindAsHostPrefixIfConfiguredTest")
public class BindAsHostPrefixIfConfiguredTest
extends BaseS3ClientTest<S3Client> {
    public void testBucket() throws IOException {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://euc/services/Walrus").build();
        BindAsHostPrefixIfConfigured binder = (BindAsHostPrefixIfConfigured)this.injector.getInstance(BindAsHostPrefixIfConfigured.class);
        request = binder.bindToRequest(request, (Object)"bucket");
        Assert.assertEquals((String)request.getRequestLine(), (String)"GET http://euc/services/Walrus/bucket HTTP/1.1");
    }

    public void testBucketWithHostnameStyle() throws IOException, SecurityException, NoSuchMethodException {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://euc/services/Walrus").build();
        BindAsHostPrefixIfConfigured binder = (BindAsHostPrefixIfConfigured)this.injector.getInstance(BindAsHostPrefixIfConfigured.class);
        request = binder.bindToRequest(request, (Object)"testbucket.example.com");
        Assert.assertEquals((String)request.getRequestLine(), (String)"GET http://euc/services/Walrus/testbucket.example.com HTTP/1.1");
        Invokable method = Reflection2.method(S3Client.class, (String)"deleteObject", (Class[])new Class[]{String.class, String.class});
        request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"testbucket.example.com", (Object)"test.jpg"));
        this.assertRequestLineEquals(request, "DELETE http://euc/services/Walrus/testbucket.example.com/test.jpg HTTP/1.1");
    }

    @Test(dataProvider="objects")
    public void testObject(String key) throws InterruptedException {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://euc/services/Walrus/object").build();
        BindAsHostPrefixIfConfigured binder = (BindAsHostPrefixIfConfigured)this.injector.getInstance(BindAsHostPrefixIfConfigured.class);
        request = binder.bindToRequest(request, (Object)"bucket");
        Assert.assertEquals((String)request.getRequestLine(), (String)"GET http://euc/services/Walrus/bucket/object HTTP/1.1");
    }

    @DataProvider(name="objects")
    public Object[][] createData() {
        return new Object[][]{{"normal"}, {"sp ace"}, {"qu?stion"}, {"unic\u20aade"}, {"path/foo"}, {"colon:"}, {"asteri*k"}, {"quote\""}, {"{great<r}"}, {"lesst>en"}, {"p|pe"}};
    }

    protected Properties setupProperties() {
        Properties properties = super.setupProperties();
        properties.setProperty("s3.endpoint", "http://euc/services/Walrus");
        properties.setProperty("jclouds.s3.service-path", "/services/Walrus");
        properties.setProperty("jclouds.s3.virtual-host-buckets", "false");
        return properties;
    }
}

