/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Module;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.jclouds.ContextBuilder;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.http.okhttp.config.OkHttpCommandExecutorServiceModule;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.options.CopyObjectOptions;
import org.jclouds.s3.options.PutObjectOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class S3ClientMockTest {
    private static final Set<Module> modules = ImmutableSet.of((Object)new OkHttpCommandExecutorServiceModule(), (Object)new ExecutorServiceModule(MoreExecutors.newDirectExecutorService()));

    static S3Client getS3Client(URL server) {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.max-retries", "1");
        return (S3Client)ContextBuilder.newBuilder((String)"s3").credentials("accessKey", "secretKey").endpoint(server.toString()).modules(modules).overrides(overrides).buildApi(S3Client.class);
    }

    public void testZeroLengthPutHasContentLengthHeader() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().addHeader("ETag", (Object)"ABCDEF"));
        server.play();
        S3Client client = S3ClientMockTest.getS3Client(server.getUrl("/"));
        S3Object nada = client.newS3Object();
        nada.getMetadata().setKey("object");
        nada.setPayload(new byte[0]);
        Assert.assertEquals((String)client.putObject("bucket", nada, new PutObjectOptions[0]), (String)"ABCDEF");
        RecordedRequest request = server.takeRequest();
        Assert.assertEquals((String)request.getRequestLine(), (String)"PUT /bucket/object HTTP/1.1");
        Assert.assertEquals((Collection)request.getHeaders("Content-Length"), (Collection)ImmutableList.of((Object)"0"));
        Assertions.assertThat((List)request.getHeaders("Expect")).isEmpty();
        server.shutdown();
    }

    public void testDirectorySeparator() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setBody("").addHeader("ETag", (Object)"ABCDEF"));
        server.play();
        S3Client client = S3ClientMockTest.getS3Client(server.getUrl("/"));
        S3Object fileInDir = client.newS3Object();
        fileInDir.getMetadata().setKey("someDir/fileName");
        fileInDir.setPayload(new byte[]{1, 2, 3, 4});
        Assert.assertEquals((String)client.putObject("bucket", fileInDir, new PutObjectOptions[0]), (String)"ABCDEF");
        RecordedRequest request = server.takeRequest();
        Assert.assertEquals((String)request.getRequestLine(), (String)"PUT /bucket/someDir/fileName HTTP/1.1");
        Assert.assertEquals((Collection)request.getHeaders("Expect"), (Collection)ImmutableList.of((Object)"100-continue"));
        server.shutdown();
    }

    public void testSourceEncodedOnCopy() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setBody("<CopyObjectResult>\n   <LastModified>2009-10-28T22:32:00</LastModified>\n   <ETag>\"9b2cf535f27731c974343645a3985328\"</ETag>\n </CopyObjectResult>"));
        server.play();
        S3Client client = S3ClientMockTest.getS3Client(server.getUrl("/"));
        client.copyObject("sourceBucket", "apples#?:$&'\"<>\u010d\u0950", "destinationBucket", "destinationObject", new CopyObjectOptions[]{CopyObjectOptions.NONE});
        RecordedRequest request = server.takeRequest();
        Assert.assertEquals((Collection)request.getHeaders("x-amz-copy-source"), (Collection)ImmutableList.of((Object)"/sourceBucket/apples%23%3F%3A%24%26%27%22%3C%3E%C4%8D%E0%A5%90"));
        server.shutdown();
    }
}

