/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.hash.Hashing;
import java.net.URI;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.domain.DeleteResult;
import org.jclouds.s3.internal.BaseS3ClientExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="S3ClientExpectTest")
public class S3ClientExpectTest
extends BaseS3ClientExpectTest {
    @Test
    public void testBucketExistsReturnsTrueOn200AndFalseOn404() {
        HttpRequest bucketFooExists = ((HttpRequest.Builder)HttpRequest.builder().method("HEAD").endpoint(URI.create("http://localhost/foo")).headers((Multimap)ImmutableMultimap.builder().put((Object)"Date", (Object)"2009-11-08T15:54:08.897Z").put((Object)"Authorization", (Object)"AWS identity:lLD0mzo2bZPIWhxlFDZoT09MKUQ=").build())).build();
        S3Client clientWhenBucketExists = (S3Client)this.requestSendsResponse(bucketFooExists, HttpResponse.builder().statusCode(200).build());
        assert (clientWhenBucketExists.bucketExists("foo"));
        S3Client clientWhenBucketDoesntExist = (S3Client)this.requestSendsResponse(bucketFooExists, HttpResponse.builder().statusCode(404).build());
        assert (!clientWhenBucketDoesntExist.bucketExists("foo"));
    }

    @Test
    public void testDeleteMultipleObjects() {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Delete><Object><Key>key1</Key></Object><Object><Key>key2</Key></Object></Delete>";
        StringPayload requestPayload = Payloads.newStringPayload((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Delete><Object><Key>key1</Key></Object><Object><Key>key2</Key></Object></Delete>");
        requestPayload.getContentMetadata().setContentType("text/xml");
        requestPayload.getContentMetadata().setContentMD5(Hashing.md5().hashString((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Delete><Object><Key>key1</Key></Object><Object><Key>key2</Key></Object></Delete>", Charsets.UTF_8));
        String response = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DeleteResult xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">\n  <Deleted>\n    <Key>key1</Key>\n  </Deleted>\n  <Deleted>\n    <Key>key1.1</Key>\n  </Deleted>\n  <Error>\n    <Key>key2</Key>\n    <Code>AccessDenied</Code>\n    <Message>Access Denied</Message>\n  </Error>\n</DeleteResult>";
        StringPayload responsePayload = Payloads.newStringPayload((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DeleteResult xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">\n  <Deleted>\n    <Key>key1</Key>\n  </Deleted>\n  <Deleted>\n    <Key>key1.1</Key>\n  </Deleted>\n  <Error>\n    <Key>key2</Key>\n    <Code>AccessDenied</Code>\n    <Message>Access Denied</Message>\n  </Error>\n</DeleteResult>");
        responsePayload.getContentMetadata().setContentType("text/xml");
        S3Client client = (S3Client)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("http://localhost/test?delete").addHeader("Date", new String[]{"2009-11-08T15:54:08.897Z"})).addHeader("Authorization", new String[]{"AWS identity:XptAJrBvfz68TEfPkhXj4R58uvE="})).payload((Payload)requestPayload)).build(), ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).addHeader("x-amz-request-id", new String[]{"7A84C3CD4437A4C0"})).addHeader("Date", new String[]{"2009-11-08T15:54:08.897Z"})).addHeader("ETag", new String[]{"437b930db84b8079c2dd804a71936b5f"})).addHeader("Server", new String[]{"AmazonS3"})).payload((Payload)responsePayload)).build());
        DeleteResult result = client.deleteObjects("test", (Iterable)ImmutableSet.of((Object)"key1", (Object)"key2"));
        Assert.assertNotNull((Object)result, (String)"result is null");
        Assert.assertEquals((Set)result.getDeleted(), (Set)ImmutableSet.of((Object)"key1", (Object)"key1.1"));
        Assert.assertEquals((int)result.getErrors().size(), (int)1);
        Assert.assertEquals(result.getErrors().get("key2"), (Object)new DeleteResult.Error("AccessDenied", "Access Denied"));
    }
}

