/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import java.util.Properties;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.internal.BaseS3ClientExpectTest;
import org.jclouds.s3.options.PutBucketOptions;
import org.jclouds.s3.options.PutObjectOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="PathBasedS3ClientExpectTest")
public class PathBasedS3ClientExpectTest
extends BaseS3ClientExpectTest {
    protected Properties setupProperties() {
        Properties overrides = super.setupProperties();
        overrides.setProperty("jclouds.s3.virtual-host-buckets", "false");
        return overrides;
    }

    @Test
    public void testBucketExistsReturnsTrueOn200AndFalseOn404() {
        HttpRequest bucketFooExists = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("HEAD").endpoint("http://localhost/foo").addHeader("Date", new String[]{"2009-11-08T15:54:08.897Z"})).addHeader("Authorization", new String[]{"AWS identity:lLD0mzo2bZPIWhxlFDZoT09MKUQ="})).build();
        S3Client clientWhenBucketExists = (S3Client)this.requestSendsResponse(bucketFooExists, HttpResponse.builder().statusCode(200).build());
        assert (clientWhenBucketExists.bucketExists("foo"));
        S3Client clientWhenBucketDoesntExist = (S3Client)this.requestSendsResponse(bucketFooExists, HttpResponse.builder().statusCode(404).build());
        assert (!clientWhenBucketDoesntExist.bucketExists("foo"));
    }

    @Test
    public void testPutBucketReturnsTrueOn200() {
        HttpRequest bucketFooExists = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("http://localhost/foo").addHeader("Date", new String[]{"2009-11-08T15:54:08.897Z"})).addHeader("Authorization", new String[]{"AWS identity:GeP4OqEL/eM+gQt+4Vtcm02gebc="})).build();
        S3Client clientWhenBucketExists = (S3Client)this.requestSendsResponse(bucketFooExists, HttpResponse.builder().statusCode(200).build());
        assert (clientWhenBucketExists.putBucketInRegion(null, "foo", new PutBucketOptions[0]));
    }

    @Test
    public void testPutObjectReturnsETagOn200() {
        HttpRequest bucketFooExists = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("http://localhost/bucket/object").addHeader("Expect", new String[]{"100-continue"})).addHeader("Date", new String[]{"2009-11-08T15:54:08.897Z"})).addHeader("Authorization", new String[]{"AWS identity:6gC0m7SYFDPwkUqY5EHV/6i9DfM="})).payload("hello world")).build();
        S3Client clientWhenBucketExists = (S3Client)this.requestSendsResponse(bucketFooExists, ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).addHeader("ETag", new String[]{"etag"})).build());
        S3Object object = clientWhenBucketExists.newS3Object();
        object.getMetadata().setKey("object");
        object.setPayload("hello world");
        Assert.assertEquals((String)clientWhenBucketExists.putObject("bucket", object, new PutObjectOptions[0]), (String)"etag");
    }
}

