/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Date;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.options.BaseHttpRequestOptions;
import org.jclouds.s3.domain.CannedAccessPolicy;

public class CopyObjectOptions
extends BaseHttpRequestOptions {
    private static final DateService dateService = new SimpleDateFormatDateService();
    public static final CopyObjectOptions NONE = new CopyObjectOptions();
    private Map<String, String> metadata;
    private CannedAccessPolicy acl = CannedAccessPolicy.PRIVATE;
    private String metadataPrefix;
    private String headerTag;

    @Inject
    public void setMetadataPrefix(@Named(value="jclouds.blobstore.metaprefix") String metadataPrefix) {
        this.metadataPrefix = metadataPrefix;
    }

    @Inject
    public void setHeaderTag(@Named(value="jclouds.aws.header.tag") String headerTag) {
        this.headerTag = headerTag;
    }

    public CopyObjectOptions overrideAcl(CannedAccessPolicy acl) {
        this.acl = (CannedAccessPolicy)((Object)Preconditions.checkNotNull((Object)((Object)acl), (Object)"acl"));
        if (!acl.equals((Object)CannedAccessPolicy.PRIVATE)) {
            this.replaceHeader("x-amz-acl", acl.toString());
        }
        return this;
    }

    public CannedAccessPolicy getAcl() {
        return this.acl;
    }

    public String getIfModifiedSince() {
        return this.getFirstHeaderOrNull("x-amz-copy-source-if-modified-since");
    }

    public String getIfUnmodifiedSince() {
        return this.getFirstHeaderOrNull("x-amz-copy-source-if-unmodified-since");
    }

    public String getIfMatch() {
        return this.getFirstHeaderOrNull("x-amz-copy-source-if-match");
    }

    public String getIfNoneMatch() {
        return this.getFirstHeaderOrNull("x-amz-copy-source-if-none-match");
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public CopyObjectOptions ifSourceModifiedSince(Date ifModifiedSince) {
        Preconditions.checkState((this.getIfMatch() == null ? 1 : 0) != 0, (Object)"ifETagMatches() is not compatible with ifModifiedSince()");
        Preconditions.checkState((this.getIfUnmodifiedSince() == null ? 1 : 0) != 0, (Object)"ifUnmodifiedSince() is not compatible with ifModifiedSince()");
        this.replaceHeader("x-amz-copy-source-if-modified-since", dateService.rfc822DateFormat((Date)Preconditions.checkNotNull((Object)ifModifiedSince, (Object)"ifModifiedSince")));
        return this;
    }

    public CopyObjectOptions ifSourceUnmodifiedSince(Date ifUnmodifiedSince) {
        Preconditions.checkState((this.getIfNoneMatch() == null ? 1 : 0) != 0, (Object)"ifETagDoesntMatch() is not compatible with ifUnmodifiedSince()");
        Preconditions.checkState((this.getIfModifiedSince() == null ? 1 : 0) != 0, (Object)"ifModifiedSince() is not compatible with ifUnmodifiedSince()");
        this.replaceHeader("x-amz-copy-source-if-unmodified-since", dateService.rfc822DateFormat((Date)Preconditions.checkNotNull((Object)ifUnmodifiedSince, (Object)"ifUnmodifiedSince")));
        return this;
    }

    public CopyObjectOptions ifSourceETagMatches(String eTag) {
        Preconditions.checkState((this.getIfNoneMatch() == null ? 1 : 0) != 0, (Object)"ifETagDoesntMatch() is not compatible with ifETagMatches()");
        Preconditions.checkState((this.getIfModifiedSince() == null ? 1 : 0) != 0, (Object)"ifModifiedSince() is not compatible with ifETagMatches()");
        this.replaceHeader("x-amz-copy-source-if-match", String.format("\"%1$s\"", Preconditions.checkNotNull((Object)eTag, (Object)"eTag")));
        return this;
    }

    public CopyObjectOptions ifSourceETagDoesntMatch(String eTag) {
        Preconditions.checkState((this.getIfMatch() == null ? 1 : 0) != 0, (Object)"ifETagMatches() is not compatible with ifETagDoesntMatch()");
        Preconditions.checkState((this.getIfUnmodifiedSince() == null ? 1 : 0) != 0, (Object)"ifUnmodifiedSince() is not compatible with ifETagDoesntMatch()");
        this.replaceHeader("x-amz-copy-source-if-none-match", String.format("\"%s\"", Preconditions.checkNotNull((Object)eTag, (Object)"ifETagDoesntMatch")));
        return this;
    }

    public Multimap<String, String> buildRequestHeaders() {
        Preconditions.checkState((this.headerTag != null ? 1 : 0) != 0, (Object)"headerTag should have been injected!");
        Preconditions.checkState((this.metadataPrefix != null ? 1 : 0) != 0, (Object)"metadataPrefix should have been injected!");
        ImmutableMultimap.Builder returnVal = ImmutableMultimap.builder();
        for (Map.Entry entry : this.headers.entries()) {
            returnVal.put((Object)((String)entry.getKey()).replace("amz", this.headerTag), entry.getValue());
        }
        if (this.metadata != null) {
            returnVal.put((Object)"x-amz-metadata-directive".replace("amz", this.headerTag), (Object)"REPLACE");
            for (Map.Entry entry : this.metadata.entrySet()) {
                String key = (String)entry.getKey();
                returnVal.put((Object)(key.startsWith(this.metadataPrefix) ? key : this.metadataPrefix + key), entry.getValue());
            }
        }
        return returnVal.build();
    }

    public CopyObjectOptions overrideMetadataWith(Map<String, String> metadata) {
        Preconditions.checkNotNull(metadata, (Object)"metadata");
        this.metadata = metadata;
        return this;
    }

    public static class Builder {
        public static CopyObjectOptions overrideAcl(CannedAccessPolicy acl) {
            CopyObjectOptions options = new CopyObjectOptions();
            return options.overrideAcl(acl);
        }

        public static CopyObjectOptions ifSourceModifiedSince(Date ifModifiedSince) {
            CopyObjectOptions options = new CopyObjectOptions();
            return options.ifSourceModifiedSince(ifModifiedSince);
        }

        public static CopyObjectOptions ifSourceUnmodifiedSince(Date ifUnmodifiedSince) {
            CopyObjectOptions options = new CopyObjectOptions();
            return options.ifSourceUnmodifiedSince(ifUnmodifiedSince);
        }

        public static CopyObjectOptions ifSourceETagMatches(String eTag) {
            CopyObjectOptions options = new CopyObjectOptions();
            return options.ifSourceETagMatches(eTag);
        }

        public static CopyObjectOptions ifSourceETagDoesntMatch(String eTag) {
            CopyObjectOptions options = new CopyObjectOptions();
            return options.ifSourceETagDoesntMatch(eTag);
        }

        public static CopyObjectOptions overrideMetadataWith(Map<String, String> metadata) {
            CopyObjectOptions options = new CopyObjectOptions();
            return options.overrideMetadataWith(metadata);
        }
    }
}

