/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.features;

import com.google.common.annotations.Beta;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import java.util.Map;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.swift.v1.binders.BindMetadataToHeaders;
import org.jclouds.openstack.swift.v1.domain.Account;
import org.jclouds.openstack.swift.v1.functions.ParseAccountFromHeaders;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Beta
public interface AccountApi {
    @Named(value="account:get")
    @HEAD
    @ResponseParser(value=ParseAccountFromHeaders.class)
    public Account get();

    @Named(value="account:updateMetadata")
    @POST
    public void updateMetadata(@BinderParam(value=BindMetadataToHeaders.BindAccountMetadataToHeaders.class) Map<String, String> var1);

    @Named(value="account:updateTemporaryUrlKey")
    @POST
    public void updateTemporaryUrlKey(@HeaderParam(value="X-Account-Meta-Temp-Url-Key") String var1);

    @Named(value="account:deleteMetadata")
    @POST
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteMetadata(@BinderParam(value=BindMetadataToHeaders.BindRemoveAccountMetadataToHeaders.class) Map<String, String> var1);
}

