/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.config;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.name.Named;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import java.io.Closeable;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.Uris;
import org.jclouds.openstack.keystone.auth.config.AuthenticationModule;
import org.jclouds.openstack.keystone.auth.domain.AuthInfo;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.domain.Endpoint;
import org.jclouds.openstack.keystone.v2_0.domain.Service;
import org.jclouds.openstack.keystone.v2_0.domain.Token;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.swift.v1.binders.TempAuthBinder;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.config.BinderUtils;

public final class SwiftAuthenticationModule
extends AuthenticationModule {
    protected void configure() {
        super.configure();
        BinderUtils.bindHttpApi((Binder)this.binder(), TempAuthApi.class);
    }

    protected Map<String, Function<Credentials, AuthInfo>> authenticationMethods(Injector i) {
        return ImmutableMap.builder().putAll(super.authenticationMethods(i)).put((Object)"tempAuthCredentials", (Object)((Function)i.getInstance(TempAuth.class))).build();
    }

    @VirtualHost
    static interface TempAuthApi
    extends Closeable {
        @Named(value="TempAuth")
        @GET
        @Consumes
        @ResponseParser(value=AdaptTempAuthResponseToAccess.class)
        public Access auth(@BinderParam(value=TempAuthBinder.class) Credentials var1);
    }

    static final class TempAuth
    implements Function<Credentials, AuthInfo> {
        private final TempAuthApi delegate;

        @Inject
        TempAuth(TempAuthApi delegate) {
            this.delegate = delegate;
        }

        public AuthInfo apply(Credentials input) {
            return this.delegate.auth(input);
        }
    }

    static final class AdaptTempAuthResponseToAccess
    implements Function<HttpResponse, Access>,
    InvocationContext<AdaptTempAuthResponseToAccess> {
        private final String identityHeaderNameUser;
        private final String apiVersion;
        private String host;
        private String username;

        @Inject
        AdaptTempAuthResponseToAccess(@ApiVersion String apiVersion, @Named(value="jclouds.swift.tempAuth.headerUser") String identityHeaderNameUser) {
            this.apiVersion = apiVersion;
            this.identityHeaderNameUser = identityHeaderNameUser;
        }

        public Access apply(HttpResponse from) {
            HttpUtils.releasePayload((HttpMessage)from);
            URI storageUrl = null;
            String authToken = null;
            for (Map.Entry entry : from.getHeaders().entries()) {
                String header = (String)entry.getKey();
                if (header.equalsIgnoreCase("X-Storage-Url")) {
                    storageUrl = this.getURI((String)entry.getValue());
                    continue;
                }
                if (!header.equalsIgnoreCase("X-Auth-Token")) continue;
                authToken = (String)entry.getValue();
            }
            if (storageUrl == null || authToken == null) {
                throw new AuthorizationException("Invalid headers in TempAuth response " + String.valueOf(from));
            }
            Date expires = new Date(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(24L));
            return Access.builder().user(User.builder().id(this.username).name(this.username).build()).token(Token.builder().id(authToken).expires(expires).build()).service(Service.builder().name("Object Storage").type("object-store").endpoint(Endpoint.builder().publicURL(storageUrl).id(this.apiVersion).region(storageUrl.getHost()).build()).build()).build();
        }

        private URI getURI(String headerValue) {
            if (headerValue == null) {
                return null;
            }
            URI toReturn = URI.create(headerValue);
            if (!"127.0.0.1".equals(toReturn.getHost())) {
                return toReturn;
            }
            return Uris.uriBuilder((URI)toReturn).host(this.host).build();
        }

        public AdaptTempAuthResponseToAccess setContext(HttpRequest request) {
            String host;
            this.host = host = request.getEndpoint().getHost();
            this.username = request.getFirstHeaderOrNull(this.identityHeaderNameUser);
            return this;
        }
    }
}

