/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.openstack.keystone.catalog.config.ServiceCatalogModule;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.blobstore.RegionScopedBlobStoreContext;
import org.jclouds.openstack.swift.v1.blobstore.config.SignUsingTemporaryUrls;
import org.jclouds.openstack.swift.v1.blobstore.config.SwiftBlobStoreContextModule;
import org.jclouds.openstack.swift.v1.config.SwiftAuthenticationModule;
import org.jclouds.openstack.swift.v1.config.SwiftHttpApiModule;
import org.jclouds.openstack.swift.v1.config.SwiftTypeAdapters;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

@AutoService(value={ApiMetadata.class})
public class SwiftApiMetadata
extends BaseHttpApiMetadata<SwiftApi> {
    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public SwiftApiMetadata() {
        this(new Builder());
    }

    protected SwiftApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.keystone.service-type", "object-store");
        properties.setProperty("jclouds.keystone.version", "2");
        properties.setProperty("jclouds.idempotent-methods", "DELETE,GET,HEAD,OPTIONS,POST,PUT");
        properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
        properties.setProperty("jclouds.swift.tempAuth.headerUser", "X-Storage-User");
        properties.setProperty("jclouds.swift.tempAuth.headerPass", "X-Storage-Pass");
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<SwiftApi, Builder> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("openstack-swift")).name("OpenStack Swift API")).identityName("${tenantName}:${userName} or ${userName}, if your keystone supports a default tenant")).credentialName("${password}")).documentation(URI.create("http://docs.openstack.org/api/openstack-object-storage/1.0/content/ch_object-storage-dev-overview.html"))).version("1")).endpointName("Keystone base url ending in /v2.0/ or TempAuth url ending in auth/v1.0/")).defaultEndpoint("http://localhost:5000/v2.0/")).defaultProperties(SwiftApiMetadata.defaultProperties())).view(Reflection2.typeToken(RegionScopedBlobStoreContext.class))).defaultModules((Set)ImmutableSet.builder().add(SwiftAuthenticationModule.class).add(ServiceCatalogModule.class).add(ServiceCatalogModule.RegionModule.class).add(SwiftTypeAdapters.class).add(SwiftHttpApiModule.class).add(SwiftBlobStoreContextModule.class).add(SignUsingTemporaryUrls.class).build());
        }

        public SwiftApiMetadata build() {
            return new SwiftApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

