/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.openstack.keystone.auth.config.AuthenticationModule;
import org.jclouds.openstack.keystone.catalog.config.KeystoneAdminURLModule;
import org.jclouds.openstack.keystone.catalog.config.ServiceCatalogModule;
import org.jclouds.openstack.keystone.v3.KeystoneApi;
import org.jclouds.openstack.keystone.v3.config.KeystoneHttpApiModule;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

@AutoService(value={ApiMetadata.class})
public class KeystoneApiMetadata
extends BaseHttpApiMetadata<KeystoneApi> {
    public Builder<?> toBuilder() {
        return (Builder)new ConcreteBuilder().fromApiMetadata((ApiMetadata)this);
    }

    public KeystoneApiMetadata() {
        this(new ConcreteBuilder());
    }

    protected KeystoneApiMetadata(Builder<?> builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
        properties.setProperty("jclouds.keystone.service-type", "identity");
        properties.setProperty("jclouds.keystone.version", "3");
        return properties;
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseHttpApiMetadata.Builder<KeystoneApi, T> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("openstack-keystone-3")).name("OpenStack Keystone 3.x API")).identityName("${domain}:${userName} or ${userName}, if your keystone supports a default project")).credentialName("${password}")).endpointName("Keystone V3 base URL")).documentation(URI.create("http://api.openstack.org/"))).version("3")).defaultEndpoint("http://localhost/identity/v3")).defaultProperties(KeystoneApiMetadata.defaultProperties())).defaultModules((Set)ImmutableSet.builder().add(AuthenticationModule.class).add(ServiceCatalogModule.class).add(KeystoneAdminURLModule.class).add(KeystoneHttpApiModule.class).build());
        }

        public KeystoneApiMetadata build() {
            return new KeystoneApiMetadata(this);
        }
    }
}

