/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.domain.Token;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@Consumes(value={"application/json"})
@RequestFilters(value={AuthenticateRequest.class})
@Endpoint(value=Identity.class)
@Path(value="/tokens/{token}")
public interface TokenApi {
    @Named(value="token:get")
    @GET
    @SelectJson(value={"token"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Token get(@PathParam(value="token") String var1);

    @Named(value="token:getuser")
    @GET
    @SelectJson(value={"user"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public User getUserOfToken(@PathParam(value="token") String var1);

    @Named(value="token:valid")
    @HEAD
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean isValid(@PathParam(value="token") String var1);

    @Named(value="token:listEndpoints")
    @GET
    @SelectJson(value={"endpoints"})
    @Path(value="/endpoints")
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<org.jclouds.openstack.keystone.v2_0.domain.Endpoint> listEndpointsForToken(@PathParam(value="token") String var1);
}

