/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.options;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Alarm;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ListAlarmsOptions
extends BaseHttpRequestOptions {
    int alarmIndex = 1;

    public ListAlarmsOptions actionPrefix(String actionPrefix) {
        Preconditions.checkNotNull((Object)actionPrefix, (Object)"actionPrefix");
        Preconditions.checkArgument((actionPrefix.length() <= 1024 ? 1 : 0) != 0, (Object)"actionPrefix must be between 1 and 1024 characters in length");
        this.formParameters.put((Object)"ActionPrefix", (Object)actionPrefix);
        return this;
    }

    public ListAlarmsOptions alarmNamePrefix(String alarmNamePrefix) {
        Preconditions.checkNotNull((Object)alarmNamePrefix, (Object)"alarmNamePrefix");
        Preconditions.checkArgument((alarmNamePrefix.length() <= 255 ? 1 : 0) != 0, (Object)"actionPrefix must be between 1 and 255 characters in length");
        this.formParameters.put((Object)"AlarmNamePrefix", (Object)alarmNamePrefix);
        return this;
    }

    public ListAlarmsOptions alarmNames(Set<String> alarmNames) {
        for (String alarmName : (Set)Preconditions.checkNotNull(alarmNames, (Object)"alarmNames")) {
            this.alarmName(alarmName);
        }
        return this;
    }

    public ListAlarmsOptions alarmName(String alarmName) {
        Preconditions.checkArgument((this.alarmIndex <= 100 ? 1 : 0) != 0, (Object)"maximum number of alarm names is 100");
        this.formParameters.put((Object)("AlarmNames.member." + this.alarmIndex), (Object)((String)Preconditions.checkNotNull((Object)alarmName, (Object)"alarmName")));
        ++this.alarmIndex;
        return this;
    }

    public ListAlarmsOptions maxRecords(int maxRecords) {
        this.formParameters.put((Object)"MaxRecords", (Object)String.valueOf(maxRecords));
        return this;
    }

    public ListAlarmsOptions state(Alarm.State state) {
        Preconditions.checkNotNull((Object)((Object)state), (Object)"state");
        Preconditions.checkArgument((state != Alarm.State.UNRECOGNIZED ? 1 : 0) != 0, (Object)"state unrecognized");
        this.formParameters.put((Object)"StateValue", (Object)state.toString());
        return this;
    }
}

