/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.options;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.http.options.BaseHttpRequestOptions;

@Beta
public class ListAlarmsForMetric
extends BaseHttpRequestOptions {
    int dimensionIndex = 1;

    public ListAlarmsForMetric dimensions(Set<Dimension> dimensions) {
        for (Dimension dimension : (Set)Preconditions.checkNotNull(dimensions, (Object)"dimensions")) {
            this.dimension(dimension);
        }
        return this;
    }

    public ListAlarmsForMetric dimension(Dimension dimension) {
        Preconditions.checkNotNull((Object)dimension, (Object)"dimension");
        Preconditions.checkArgument((this.dimensionIndex <= 10 ? 1 : 0) != 0, (Object)"maximum number of dimensions is 10");
        this.formParameters.put((Object)("Dimensions.member." + this.dimensionIndex + ".Name"), (Object)dimension.getName());
        this.formParameters.put((Object)("Dimensions.member." + this.dimensionIndex + ".Value"), (Object)dimension.getValue());
        ++this.dimensionIndex;
        return this;
    }

    public ListAlarmsForMetric metricName(String metricName) {
        Preconditions.checkNotNull((Object)metricName, (Object)"metricName");
        Preconditions.checkArgument((metricName.length() <= 255 ? 1 : 0) != 0, (Object)"metricName must be between 1 and 255 characters in length");
        this.formParameters.put((Object)"MetricName", (Object)metricName);
        return this;
    }

    public ListAlarmsForMetric namespace(String namespace) {
        Preconditions.checkNotNull((Object)namespace, (Object)"namespace");
        Preconditions.checkArgument((namespace.length() <= 255 ? 1 : 0) != 0, (Object)"namespace must be between 1 and 255 characters in length");
        this.formParameters.put((Object)"Namespace", (Object)namespace);
        return this;
    }

    public ListAlarmsForMetric period(int period) {
        this.formParameters.put((Object)"Period", (Object)String.valueOf(period));
        return this;
    }

    public ListAlarmsForMetric statistic(Statistics statistic) {
        Preconditions.checkNotNull((Object)((Object)statistic), (Object)"statistic");
        Preconditions.checkArgument((statistic != Statistics.UNRECOGNIZED ? 1 : 0) != 0, (Object)"statistic unrecognized");
        this.formParameters.put((Object)"Statistic", (Object)statistic.toString());
        return this;
    }

    public ListAlarmsForMetric unit(Unit unit) {
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit");
        Preconditions.checkArgument((unit != Unit.UNRECOGNIZED ? 1 : 0) != 0, (Object)"unit unrecognized");
        this.formParameters.put((Object)"Unit", (Object)unit.toString());
        return this;
    }
}

