/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.domain.MutableContentMetadata;
import org.jclouds.atmos.domain.SystemMetadata;
import org.jclouds.atmos.domain.UserMetadata;
import org.jclouds.atmos.domain.internal.DelegatingMutableContentMetadata;
import org.jclouds.http.internal.PayloadEnclosingImpl;
import org.jclouds.io.Payload;

public class AtmosObjectImpl
extends PayloadEnclosingImpl
implements AtmosObject,
Comparable<AtmosObject> {
    private final UserMetadata userMetadata;
    private final SystemMetadata systemMetadata;
    private MutableContentMetadata contentMetadata;
    private Multimap<String, String> allHeaders = LinkedHashMultimap.create();

    @Override
    public SystemMetadata getSystemMetadata() {
        return this.systemMetadata;
    }

    @Override
    public UserMetadata getUserMetadata() {
        return this.userMetadata;
    }

    public AtmosObjectImpl(MutableContentMetadata contentMetadata, SystemMetadata systemMetadata, UserMetadata userMetadata) {
        this.contentMetadata = contentMetadata;
        this.systemMetadata = systemMetadata;
        this.userMetadata = userMetadata;
    }

    @Inject
    public AtmosObjectImpl(MutableContentMetadata contentMetadata) {
        this(contentMetadata, null, new UserMetadata());
    }

    @Override
    public MutableContentMetadata getContentMetadata() {
        return this.contentMetadata;
    }

    @Override
    public Multimap<String, String> getAllHeaders() {
        return this.allHeaders;
    }

    @Override
    public void setAllHeaders(Multimap<String, String> allHeaders) {
        this.allHeaders = (Multimap)Preconditions.checkNotNull(allHeaders, (Object)"allHeaders");
    }

    @Override
    public int compareTo(AtmosObject o) {
        if (this.getContentMetadata().getName() == null) {
            return -1;
        }
        return this == o ? 0 : this.getContentMetadata().getName().compareTo(o.getContentMetadata().getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.contentMetadata == null ? 0 : this.contentMetadata.hashCode());
        result = 31 * result + (this.systemMetadata == null ? 0 : this.systemMetadata.hashCode());
        result = 31 * result + (this.userMetadata == null ? 0 : this.userMetadata.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AtmosObjectImpl other = (AtmosObjectImpl)obj;
        if (this.contentMetadata == null ? other.contentMetadata != null : !this.contentMetadata.equals(other.contentMetadata)) {
            return false;
        }
        if (this.systemMetadata == null ? other.systemMetadata != null : !this.systemMetadata.equals(other.systemMetadata)) {
            return false;
        }
        return !(this.userMetadata == null ? other.userMetadata != null : !this.userMetadata.equals(other.userMetadata));
    }

    public String toString() {
        return "[contentMetadata=" + String.valueOf(this.contentMetadata) + "]";
    }

    public void setPayload(Payload data) {
        this.payload = data;
        this.contentMetadata = new DelegatingMutableContentMetadata(this.contentMetadata.getUri(), this.contentMetadata.getName(), this.contentMetadata.getPath(), this.payload.getContentMetadata());
    }

    @Singleton
    public static class AtmosObjectFactory
    implements AtmosObject.Factory {
        @Inject
        Provider<MutableContentMetadata> metadataProvider;

        @Override
        public AtmosObject create(MutableContentMetadata contentMetadata) {
            return new AtmosObjectImpl(contentMetadata != null ? contentMetadata : (MutableContentMetadata)this.metadataProvider.get());
        }

        @Override
        public AtmosObject create(SystemMetadata systemMetadata, UserMetadata userMetadata) {
            return new AtmosObjectImpl((MutableContentMetadata)this.metadataProvider.get(), systemMetadata, userMetadata);
        }

        @Override
        public AtmosObject create(MutableContentMetadata contentMetadata, SystemMetadata systemMetadata, UserMetadata userMetadata) {
            return new AtmosObjectImpl(contentMetadata, systemMetadata, userMetadata);
        }
    }
}

