/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.jclouds.atmos.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;

@Singleton
public class ObjectToBlob
implements Function<AtmosObject, Blob> {
    private final Blob.Factory blobFactory;
    private final ObjectToBlobMetadata object2BlobMd;

    @Inject
    ObjectToBlob(Blob.Factory blobFactory, ObjectToBlobMetadata object2BlobMd) {
        this.blobFactory = blobFactory;
        this.object2BlobMd = object2BlobMd;
    }

    public Blob apply(AtmosObject from) {
        if (from == null) {
            return null;
        }
        Blob blob = this.blobFactory.create(this.object2BlobMd.apply(from));
        blob.setPayload((Payload)Preconditions.checkNotNull((Object)from.getPayload(), (Object)("payload: " + String.valueOf(from))));
        HttpUtils.copy((ContentMetadata)from.getContentMetadata(), (MutableContentMetadata)blob.getPayload().getContentMetadata());
        blob.setAllHeaders(from.getAllHeaders());
        return blob;
    }
}

