/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpamTrapHandler
implements RcptHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpamTrapHandler.class);
    private final Map<String, Long> blockedIps = new HashMap<String, Long>();
    private Collection<String> spamTrapRecips = new ArrayList<String>();
    protected long blockTime = 4320000L;

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public void setSpamTrapRecipients(Collection<String> spamTrapRecips) {
        this.spamTrapRecips = spamTrapRecips;
    }

    public void setBlockTime(long blockTime) {
        this.blockTime = blockTime;
    }

    @Override
    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        String address = session.getRemoteAddress().getAddress().getHostAddress();
        if (this.isBlocked(address, session)) {
            return HookResult.DENY;
        }
        if (this.spamTrapRecips.contains(rcpt.toString().toLowerCase(Locale.US))) {
            this.addIp(address, session);
            return HookResult.DENY;
        }
        return HookResult.DECLINED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBlocked(String ip, SMTPSession session) {
        Long rawTime = this.blockedIps.get(ip);
        if (rawTime != null) {
            long blockTime = rawTime;
            if (blockTime > System.currentTimeMillis()) {
                LOGGER.debug("BlockList contain Ip {}", (Object)ip);
                return true;
            }
            LOGGER.debug("Remove ip {} from blockList", (Object)ip);
            Map<String, Long> map = this.blockedIps;
            synchronized (map) {
                this.blockedIps.remove(ip);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIp(String ip, SMTPSession session) {
        long bTime = System.currentTimeMillis() + this.blockTime;
        LOGGER.debug("Add ip {} for {} to blockList", (Object)ip, (Object)bTime);
        Map<String, Long> map = this.blockedIps;
        synchronized (map) {
            this.blockedIps.put(ip, bTime);
        }
    }
}

