/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HeloHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.RcptHook;

public class ResolvableEhloHeloHandler
implements RcptHook,
HeloHook {
    public static final String BAD_EHLO_HELO = "BAD_EHLO_HELO";

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    protected void checkEhloHelo(SMTPSession session, String argument) {
        if (this.isBadHelo(session, argument)) {
            session.setAttachment(BAD_EHLO_HELO, "true", ProtocolSession.State.Transaction);
        }
    }

    protected String resolve(String host) throws UnknownHostException {
        return InetAddress.getByName(host).getHostName();
    }

    protected boolean isBadHelo(SMTPSession session, String argument) {
        try {
            this.resolve(argument);
        }
        catch (UnknownHostException e) {
            return true;
        }
        return false;
    }

    protected boolean check(SMTPSession session, MailAddress rcpt) {
        return session.getAttachment(BAD_EHLO_HELO, ProtocolSession.State.Transaction) != null;
    }

    @Override
    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        if (this.check(session, rcpt)) {
            return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("501").smtpDescription(DSNStatus.getStatus(5, "5.4") + " Provided EHLO/HELO " + session.getAttachment("CURRENT_HELO_NAME", ProtocolSession.State.Connection) + " can not resolved.").build();
        }
        return HookResult.DECLINED;
    }

    @Override
    public HookResult doHelo(SMTPSession session, String helo) {
        this.checkEhloHelo(session, helo);
        return HookResult.DECLINED;
    }
}

