/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSRBLHandler
implements RcptHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(DNSRBLHandler.class);
    private String[] whitelist;
    private String[] blacklist;
    private boolean getDetail = false;
    private final String blocklistedDetail;
    public static final String RBL_BLOCKLISTED_MAIL_ATTRIBUTE_NAME = "org.apache.james.smtpserver.rbl.blocklisted";
    public static final String RBL_DETAIL_MAIL_ATTRIBUTE_NAME = "org.apache.james.smtpserver.rbl.detail";

    public DNSRBLHandler() {
        this.blocklistedDetail = null;
    }

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public void setWhitelist(String[] whitelist) {
        if (whitelist != null) {
            this.whitelist = new String[whitelist.length];
            for (int i = 0; i < whitelist.length; ++i) {
                this.whitelist[i] = new String(whitelist[i]);
            }
        }
        this.whitelist = whitelist;
    }

    public void setBlacklist(String[] blacklist) {
        if (blacklist != null) {
            this.blacklist = new String[blacklist.length];
            for (int i = 0; i < blacklist.length; ++i) {
                this.blacklist[i] = new String(blacklist[i]);
            }
        }
    }

    public void setGetDetail(boolean getDetail) {
        this.getDetail = getDetail;
    }

    public void checkDNSRBL(SMTPSession session, String ipAddress) {
        if (session.isRelayingAllowed()) {
            LOGGER.info("Ipaddress {} is allowed to relay. Don't check it", (Object)session.getRemoteAddress().getAddress());
            return;
        }
        if (this.whitelist != null || this.blacklist != null) {
            String[] rblList;
            StringBuffer sb = new StringBuffer();
            StringTokenizer st = new StringTokenizer(ipAddress, " .", false);
            while (st.hasMoreTokens()) {
                sb.insert(0, st.nextToken() + ".");
            }
            String reversedOctets = sb.toString();
            if (this.whitelist != null) {
                for (String rbl : rblList = this.whitelist) {
                    if (this.resolve(reversedOctets + rbl)) {
                        LOGGER.info("Connection from {} whitelisted by {}", (Object)ipAddress, (Object)rbl);
                        return;
                    }
                    LOGGER.debug("IpAddress {} not listed on {}", (Object)session.getRemoteAddress().getAddress(), (Object)rbl);
                }
            }
            if (this.blacklist != null) {
                for (String rbl : rblList = this.blacklist) {
                    if (this.resolve(reversedOctets + rbl)) {
                        Collection<String> txt;
                        LOGGER.info("Connection from {} restricted by {} to SMTP AUTH/postmaster/abuse.", (Object)ipAddress, (Object)rbl);
                        if (this.getDetail && !(txt = this.resolveTXTRecords(reversedOctets + rbl)).isEmpty()) {
                            String blocklistedDetail = txt.iterator().next().toString();
                            session.setAttachment(RBL_DETAIL_MAIL_ATTRIBUTE_NAME, blocklistedDetail, ProtocolSession.State.Connection);
                        }
                        session.setAttachment(RBL_BLOCKLISTED_MAIL_ATTRIBUTE_NAME, "true", ProtocolSession.State.Connection);
                        return;
                    }
                    LOGGER.debug("unknown host exception thrown: {}", (Object)rbl);
                }
            }
        }
    }

    @Override
    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        String blocklisted;
        this.checkDNSRBL(session, session.getRemoteAddress().getAddress().getHostAddress());
        if (!session.isRelayingAllowed() && (blocklisted = (String)session.getAttachment(RBL_BLOCKLISTED_MAIL_ATTRIBUTE_NAME, ProtocolSession.State.Connection)) != null) {
            if (this.blocklistedDetail == null) {
                return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpDescription(DSNStatus.getStatus(5, "7.1") + " Rejected: unauthenticated e-mail from " + session.getRemoteAddress().getAddress() + " is restricted.  Contact the postmaster for details.").build();
            }
            return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpDescription(DSNStatus.getStatus(5, "7.1") + " " + this.blocklistedDetail).build();
        }
        return HookResult.DECLINED;
    }

    protected boolean resolve(String ip) {
        try {
            InetAddress.getByName(ip);
            return true;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    protected Collection<String> resolveTXTRecords(String ip) {
        return Collections.emptyList();
    }
}

