/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.esmtp;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.DataLineFilter;
import org.apache.james.protocols.smtp.core.esmtp.EhloExtension;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.MailParametersHook;
import org.apache.james.protocols.smtp.hook.MessageHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSizeEsmtpExtension
implements MailParametersHook,
EhloExtension,
DataLineFilter,
MessageHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailSizeEsmtpExtension.class);
    private static final String MESG_SIZE = "MESG_SIZE";
    private static final String MESG_FAILED = "MESG_FAILED";
    private static final String[] MAIL_PARAMS = new String[]{"SIZE"};
    private static final HookResult SYNTAX_ERROR = HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("501").smtpDescription(DSNStatus.getStatus(5, "5.4") + " Syntactically incorrect value for SIZE parameter").build();
    private static final HookResult QUOTA_EXCEEDED = HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("552").smtpDescription(DSNStatus.getStatus(5, "3.4") + " Message size exceeds fixed maximum message size").build();
    public static final int SINGLE_CHARACTER_LINE = 3;
    public static final int DOT_BYTE = 46;

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    @Override
    public HookResult doMailParameter(SMTPSession session, String paramName, String paramValue) {
        MaybeSender tempSender = (MaybeSender)session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction);
        return this.doMailSize(session, paramValue, tempSender);
    }

    @Override
    public String[] getMailParamNames() {
        return MAIL_PARAMS;
    }

    @Override
    public List<String> getImplementedEsmtpFeatures(SMTPSession session) {
        long maxMessageSize = session.getConfiguration().getMaxMessageSize();
        if (maxMessageSize > 0L) {
            return Arrays.asList("SIZE " + maxMessageSize);
        }
        return Collections.EMPTY_LIST;
    }

    private HookResult doMailSize(SMTPSession session, String mailOptionValue, MaybeSender tempSender) {
        int size = 0;
        try {
            size = Integer.parseInt(mailOptionValue);
        }
        catch (NumberFormatException pe) {
            LOGGER.error("Rejected syntactically incorrect value for SIZE parameter.");
            return SYNTAX_ERROR;
        }
        LOGGER.debug("MAIL command option SIZE received with value {}.", (Object)size);
        long maxMessageSize = session.getConfiguration().getMaxMessageSize();
        if (maxMessageSize > 0L && (long)size > maxMessageSize) {
            LOGGER.error("Rejected message from {} to {} of size {} exceeding system maximum message size of {} based on SIZE option.", new Object[]{tempSender, session.getRemoteAddress().getAddress().getHostAddress(), size, maxMessageSize});
            return QUOTA_EXCEEDED;
        }
        session.setAttachment(MESG_SIZE, size, ProtocolSession.State.Transaction);
        return null;
    }

    @Override
    public Response onLine(SMTPSession session, ByteBuffer line, LineHandler<SMTPSession> next) {
        Boolean failed = (Boolean)session.getAttachment(MESG_FAILED, ProtocolSession.State.Transaction);
        if (failed != null && failed.booleanValue()) {
            if (this.isDataTerminated(line)) {
                line.rewind();
                next.onLine((ProtocolSession)session, line);
                return new SMTPResponse("552", "Quota exceeded");
            }
            return null;
        }
        if (this.isDataTerminated(line)) {
            line.rewind();
            return next.onLine((ProtocolSession)session, line);
        }
        line.rewind();
        Long currentSize = (Long)session.getAttachment("CURRENT_SIZE", ProtocolSession.State.Transaction);
        Long newSize = currentSize == null ? Long.valueOf(line.remaining()) : Long.valueOf(currentSize.intValue() + line.remaining());
        session.setAttachment("CURRENT_SIZE", newSize, ProtocolSession.State.Transaction);
        if (session.getConfiguration().getMaxMessageSize() > 0L && (long)newSize.intValue() > session.getConfiguration().getMaxMessageSize()) {
            session.setAttachment(MESG_FAILED, Boolean.TRUE, ProtocolSession.State.Transaction);
            return null;
        }
        line.rewind();
        return next.onLine((ProtocolSession)session, line);
    }

    private boolean isDataTerminated(ByteBuffer line) {
        return line.remaining() == 3 && line.get() == 46;
    }

    @Override
    public HookResult onMessage(SMTPSession session, MailEnvelope mail) {
        Boolean failed = (Boolean)session.getAttachment(MESG_FAILED, ProtocolSession.State.Transaction);
        if (failed != null && failed.booleanValue()) {
            LOGGER.error("Rejected message from {} from {} exceeding system maximum message size of {}", new Object[]{session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction), session.getRemoteAddress().getAddress().getHostAddress(), session.getConfiguration().getMaxMessageSize()});
            return QUOTA_EXCEEDED;
        }
        return HookResult.DECLINED;
    }
}

