/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.MailAddress;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractAddHeadersFilter;

public class ReceivedDataLineFilter
extends AbstractAddHeadersFilter {
    private static final String EHLO = "EHLO";
    private static final String SMTP = "SMTP";
    private static final String ESMTPA = "ESMTPA";
    private static final String ESMTP = "ESMTP";
    private static final ThreadLocal<DateFormat> DATEFORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z (zzz)", Locale.US));

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    protected String getServiceType(SMTPSession session, String heloMode) {
        if (EHLO.equals(heloMode)) {
            if (session.getUser() == null) {
                return ESMTP;
            }
            return ESMTPA;
        }
        return SMTP;
    }

    @Override
    protected AbstractAddHeadersFilter.Location getLocation() {
        return AbstractAddHeadersFilter.Location.Prefix;
    }

    @Override
    protected Collection<AbstractAddHeadersFilter.Header> headers(SMTPSession session) {
        StringBuilder headerLineBuffer = new StringBuilder();
        String heloMode = (String)session.getAttachment("CURRENT_HELO_MODE", ProtocolSession.State.Connection);
        String heloName = (String)session.getAttachment("CURRENT_HELO_NAME", ProtocolSession.State.Connection);
        headerLineBuffer.append("from ").append(session.getRemoteAddress().getHostName());
        if (heloName != null) {
            headerLineBuffer.append(" (").append(heloMode).append(" ").append(heloName).append(")");
        }
        headerLineBuffer.append(" ([").append(session.getRemoteAddress().getAddress().getHostAddress()).append("])");
        AbstractAddHeadersFilter.Header header = new AbstractAddHeadersFilter.Header("Received", headerLineBuffer.toString());
        headerLineBuffer = new StringBuilder();
        headerLineBuffer.append("by ").append(session.getConfiguration().getHelloName()).append(" (").append(session.getConfiguration().getSoftwareName()).append(") with ").append(this.getServiceType(session, heloMode));
        headerLineBuffer.append(" ID ").append(session.getSessionID());
        if (((Collection)session.getAttachment("RCPT_LIST", ProtocolSession.State.Transaction)).size() == 1) {
            header.add(headerLineBuffer.toString());
            headerLineBuffer = new StringBuilder();
            headerLineBuffer.append("for <").append(((MailAddress)((List)session.getAttachment("RCPT_LIST", ProtocolSession.State.Transaction)).get(0)).toString()).append(">;");
        } else {
            headerLineBuffer.append(";");
        }
        header.add(headerLineBuffer.toString());
        headerLineBuffer = new StringBuilder();
        headerLineBuffer.append(DATEFORMAT.get().format(new Date()));
        header.add(headerLineBuffer.toString());
        return Arrays.asList(header);
    }
}

