/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import javax.inject.Inject;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HeloHook;
import org.apache.james.protocols.smtp.hook.HookResult;

public class HeloCmdHandler
extends AbstractHookableCmdHandler<HeloHook> {
    private static final String COMMAND_NAME = "HELO";
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"HELO");
    private static final Response DOMAIN_REQUIRED = new SMTPResponse("501", DSNStatus.getStatus(5, "5.4") + " Domain address required: " + "HELO").immutable();

    @Inject
    public HeloCmdHandler(MetricFactory metricFactory) {
        super(metricFactory);
    }

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    protected Response doCoreCmd(SMTPSession session, String command, String parameters) {
        session.setAttachment("CURRENT_HELO_MODE", COMMAND_NAME, ProtocolSession.State.Connection);
        StringBuilder response = new StringBuilder();
        response.append(session.getConfiguration().getHelloName()).append(" Hello ").append(parameters).append(" [").append(session.getRemoteAddress().getAddress().getHostAddress()).append("])");
        return new SMTPResponse("250", response);
    }

    @Override
    protected Response doFilterChecks(SMTPSession session, String command, String parameters) {
        session.resetState();
        if (parameters == null) {
            return DOMAIN_REQUIRED;
        }
        session.setAttachment("CURRENT_HELO_NAME", parameters, ProtocolSession.State.Connection);
        return null;
    }

    @Override
    protected Class<HeloHook> getHookInterface() {
        return HeloHook.class;
    }

    @Override
    protected HookResult callHook(HeloHook rawHook, SMTPSession session, String parameters) {
        return rawHook.doHelo(session, parameters);
    }
}

