/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp;

import java.util.Collection;
import org.apache.james.protocols.api.ProtocolConfiguration;
import org.apache.james.protocols.api.ProtocolSessionImpl;
import org.apache.james.protocols.api.ProtocolTransport;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.smtp.SMTPConfiguration;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;

public class SMTPSessionImpl
extends ProtocolSessionImpl
implements SMTPSession {
    private static final Response LINE_LENGTH_EXCEEDED = new SMTPResponse("500", "Line length exceeded. See RFC 2821 #4.5.3.1.").immutable();
    private static final Response FATAL_ERROR = new SMTPResponse("451", "Unable to process request").immutable();
    private boolean relayingAllowed;
    private boolean needsCommandInjectionDetection;

    public SMTPSessionImpl(ProtocolTransport transport, SMTPConfiguration config) {
        super(transport, (ProtocolConfiguration)config);
        this.relayingAllowed = config.isRelayingAllowed(this.getRemoteAddress().getAddress().getHostAddress());
        this.needsCommandInjectionDetection = true;
    }

    @Override
    public boolean needsCommandInjectionDetection() {
        return this.needsCommandInjectionDetection;
    }

    @Override
    public void startDetectingCommadInjection() {
        this.needsCommandInjectionDetection = true;
    }

    @Override
    public void stopDetectingCommandInjection() {
        this.needsCommandInjectionDetection = false;
    }

    @Override
    public boolean isRelayingAllowed() {
        return this.relayingAllowed;
    }

    public void resetState() {
        Object currentHeloMode = this.getState().get("CURRENT_HELO_MODE");
        this.getState().clear();
        if (currentHeloMode != null) {
            this.getState().put("CURRENT_HELO_MODE", currentHeloMode);
        }
    }

    @Override
    public int getRcptCount() {
        int count = 0;
        if (this.getState().get("RCPT_LIST") != null) {
            count = ((Collection)this.getState().get("RCPT_LIST")).size();
        }
        return count;
    }

    @Override
    public boolean isAuthSupported() {
        return this.getConfiguration().isAuthRequired(this.getRemoteAddress().getAddress().getHostAddress());
    }

    @Override
    public void setRelayingAllowed(boolean relayingAllowed) {
        this.relayingAllowed = relayingAllowed;
    }

    public Response newLineTooLongResponse() {
        return LINE_LENGTH_EXCEEDED;
    }

    public Response newFatalErrorResponse() {
        return FATAL_ERROR;
    }

    @Override
    public SMTPConfiguration getConfiguration() {
        return (SMTPConfiguration)this.config;
    }
}

