/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.api;

import java.util.function.Supplier;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.TimeMetric;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface MetricFactory {
    public Metric generate(String var1);

    public TimeMetric timer(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T runPublishingTimerMetric(String name, Supplier<T> operation) {
        TimeMetric timer = this.timer(name);
        try {
            T t = operation.get();
            return t;
        }
        finally {
            timer.stopAndPublish();
        }
    }

    default public <T> Mono<T> runPublishingTimerMetric(String name, Mono<T> mono) {
        TimeMetric timer = this.timer(name);
        return mono.doOnSuccess(success -> timer.stopAndPublish());
    }

    default public <T> Flux<T> runPublishingTimerMetric(String name, Flux<T> flux) {
        TimeMetric timer = this.timer(name);
        return flux.doOnComplete(timer::stopAndPublish);
    }

    default public void runPublishingTimerMetric(String name, Runnable runnable) {
        this.runPublishingTimerMetric(name, () -> {
            runnable.run();
            return null;
        });
    }
}

