/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.retry;

import com.nurkiewicz.asyncretry.AsyncRetryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryExecutorUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RetryExecutorUtil.class);
    private static final int INITIAL_DELAY_MILLIS = 500;
    private static final int MULTIPLIER = 2;

    @SafeVarargs
    public static AsyncRetryExecutor retryOnExceptions(AsyncRetryExecutor executor, int maxRetries, int minDelay, Class<? extends Throwable> ... clazz) {
        LOG.info("The action should retry when {} and retry to {} times if needed", clazz, (Object)maxRetries);
        return executor.withExponentialBackoff(500L, 2.0).withProportionalJitter().retryOn((Class[])clazz).withMaxRetries(maxRetries).withMinDelay((long)minDelay);
    }
}

