/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.james.util.FluentFutureStream;

public class Runnables {
    public static void runParallel(Runnable ... runnables) {
        Stream<Runnable> stream = Arrays.stream(runnables);
        Runnables.runParrallelStream(stream);
    }

    public static void runParrallelStream(Stream<Runnable> stream) {
        FluentFutureStream.of(stream.map(runnable -> CompletableFuture.supplyAsync(Runnables.toVoidSupplier(runnable)))).join();
    }

    private static Supplier<Void> toVoidSupplier(Runnable runnable) {
        return () -> {
            runnable.run();
            return null;
        };
    }
}

