/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.apache.james.util.CompletableFutureUtil;
import org.apache.james.util.OptionalUtils;
import org.apache.james.util.StreamUtils;

public class FluentFutureStream<T> {
    private final CompletableFuture<Stream<T>> completableFuture;

    public static <T> FluentFutureStream<T> unboxStream(FluentFutureStream<Stream<T>> streams) {
        return FluentFutureStream.of(streams.completableFuture().thenApply(StreamUtils::flatten));
    }

    public static <T> FluentFutureStream<T> unboxOptional(FluentFutureStream<Optional<T>> optionals) {
        return FluentFutureStream.unboxStream(optionals.map(OptionalUtils::toStream));
    }

    public static <T> FluentFutureStream<T> unboxFuture(FluentFutureStream<CompletableFuture<T>> futures) {
        return FluentFutureStream.of(futures.completableFuture().thenCompose(CompletableFutureUtil::allOf));
    }

    public static <T> FluentFutureStream<T> unboxFluentFuture(FluentFutureStream<FluentFutureStream<T>> futures) {
        return FluentFutureStream.unboxStream(FluentFutureStream.unboxFuture(futures.map(FluentFutureStream::completableFuture)));
    }

    public static <T> FluentFutureStream<T> unboxFutureOptional(FluentFutureStream<CompletableFuture<Optional<T>>> futures) {
        return FluentFutureStream.unboxOptional(FluentFutureStream.unboxFuture(futures));
    }

    public static <T> FluentFutureStream<T> of(CompletableFuture<Stream<T>> completableFuture) {
        return new FluentFutureStream<T>(completableFuture);
    }

    public static <T, U> FluentFutureStream<U> of(Stream<CompletableFuture<T>> completableFuture, Function<FluentFutureStream<T>, FluentFutureStream<U>> unboxer) {
        return unboxer.apply(FluentFutureStream.of(completableFuture));
    }

    public static <T> FluentFutureStream<T> of(Stream<CompletableFuture<T>> completableFutureStream) {
        return new FluentFutureStream<T>(CompletableFutureUtil.allOf(completableFutureStream));
    }

    @SafeVarargs
    public static <T> FluentFutureStream<T> ofFutures(CompletableFuture<T> ... completableFutures) {
        return FluentFutureStream.of(Arrays.stream(completableFutures));
    }

    private FluentFutureStream(CompletableFuture<Stream<T>> completableFuture) {
        this.completableFuture = completableFuture;
    }

    public FluentFutureStream<T> performOnAll(Function<T, CompletableFuture<Void>> action) {
        return this.map(t -> ((CompletableFuture)action.apply(t)).thenApply(any -> t), FluentFutureStream::unboxFuture);
    }

    public <U> FluentFutureStream<U> map(Function<T, U> function) {
        return FluentFutureStream.of(CompletableFutureUtil.map(this.completableFuture(), function));
    }

    public <U, V> FluentFutureStream<V> map(Function<T, U> function, Function<FluentFutureStream<U>, FluentFutureStream<V>> unboxer) {
        return unboxer.apply(this.map(function));
    }

    public FluentFutureStream<T> filter(Predicate<T> predicate) {
        return FluentFutureStream.of(this.completableFuture.thenApply(stream -> stream.filter(predicate)));
    }

    public FluentFutureStream<T> thenFilter(Function<T, CompletableFuture<Boolean>> futurePredicate) {
        return this.map(t -> ((CompletableFuture)futurePredicate.apply(t)).thenApply(isKept -> Optional.of(t).filter((? super T any) -> isKept)), FluentFutureStream::unboxFutureOptional);
    }

    public CompletableFuture<Optional<T>> reduce(BinaryOperator<T> combiner) {
        return CompletableFutureUtil.reduce(combiner, this.completableFuture);
    }

    public CompletableFuture<T> reduce(T emptyAccumulator, BinaryOperator<T> combiner) {
        return CompletableFutureUtil.reduce(combiner, this.completableFuture, emptyAccumulator);
    }

    public FluentFutureStream<T> sorted(Comparator<T> comparator) {
        return FluentFutureStream.of(CompletableFutureUtil.sorted(this.completableFuture(), comparator));
    }

    public CompletableFuture<Stream<T>> completableFuture() {
        return this.completableFuture;
    }

    public <C> CompletableFuture<C> collect(Collector<T, ?, C> collector) {
        return this.completableFuture.thenApply(stream -> stream.collect(collector));
    }

    public Stream<T> join() {
        return this.completableFuture().join();
    }
}

