/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.memory;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.core.MailAddress;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.server.core.MailImpl;
import org.apache.mailet.Mail;
import org.threeten.extra.Temporals;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MemoryMailQueueFactory
implements MailQueueFactory<ManageableMailQueue> {
    private final ConcurrentHashMap<String, MemoryMailQueue> mailQueues = new ConcurrentHashMap();
    private final MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory;

    @Inject
    public MemoryMailQueueFactory(MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory) {
        this.mailQueueItemDecoratorFactory = mailQueueItemDecoratorFactory;
    }

    public Set<ManageableMailQueue> listCreatedMailQueues() {
        return ImmutableSet.copyOf(this.mailQueues.values());
    }

    public Optional<ManageableMailQueue> getQueue(String name) {
        return Optional.ofNullable((ManageableMailQueue)this.mailQueues.get(name));
    }

    public MemoryMailQueue createQueue(String name) {
        MemoryMailQueue newMailQueue = new MemoryMailQueue(name, this.mailQueueItemDecoratorFactory);
        return Optional.ofNullable(this.mailQueues.putIfAbsent(name, newMailQueue)).orElse(newMailQueue);
    }

    public static class MemoryMailQueueItem
    implements MailQueue.MailQueueItem,
    Delayed {
        private final Mail mail;
        private final MemoryMailQueue queue;
        private final ZonedDateTime delivery;

        public MemoryMailQueueItem(Mail mail, MemoryMailQueue queue, ZonedDateTime delivery) {
            this.mail = mail;
            this.queue = queue;
            this.delivery = delivery;
        }

        public Mail getMail() {
            return this.mail;
        }

        public void done(boolean success) throws MailQueue.MailQueueException {
            this.queue.markProcessingAsFinished(this);
            if (!success) {
                this.queue.enQueue(this.mail);
            }
        }

        @Override
        public long getDelay(TimeUnit unit) {
            try {
                return ZonedDateTime.now().until(this.delivery, Temporals.chronoUnit((TimeUnit)unit));
            }
            catch (ArithmeticException e) {
                return Long.MAX_VALUE;
            }
        }

        @Override
        public int compareTo(Delayed o) {
            return Math.toIntExact(this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS));
        }
    }

    public static class MemoryMailQueue
    implements ManageableMailQueue {
        private final DelayQueue<MemoryMailQueueItem> mailItems = new DelayQueue();
        private final LinkedBlockingDeque<MemoryMailQueueItem> inProcessingMailItems = new LinkedBlockingDeque();
        private final String name;
        private final Flux<MailQueue.MailQueueItem> flux;

        public MemoryMailQueue(String name, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory) {
            this.name = name;
            this.flux = Mono.fromCallable(this.mailItems::take).repeat().flatMap(item -> Mono.just((Object)this.inProcessingMailItems.add((MemoryMailQueueItem)item)).thenReturn(item)).map(arg_0 -> ((MailQueueItemDecoratorFactory)mailQueueItemDecoratorFactory).decorate(arg_0));
        }

        public String getName() {
            return this.name;
        }

        public void enQueue(Mail mail, Duration delay) throws MailQueue.MailQueueException {
            ZonedDateTime nextDelivery = this.calculateNextDelivery(delay);
            try {
                this.mailItems.put(new MemoryMailQueueItem(this.cloneMail(mail), this, nextDelivery));
            }
            catch (MessagingException e) {
                throw new MailQueue.MailQueueException("Error while copying mail " + mail.getName(), (Exception)((Object)e));
            }
        }

        private ZonedDateTime calculateNextDelivery(Duration delay) {
            if (!delay.isNegative()) {
                try {
                    return ZonedDateTime.now().plus(delay);
                }
                catch (ArithmeticException | DateTimeException e) {
                    return Instant.ofEpochMilli(Long.MAX_VALUE).atZone(ZoneId.of("UTC"));
                }
            }
            return ZonedDateTime.now();
        }

        public void enQueue(Mail mail) throws MailQueue.MailQueueException {
            this.enQueue(mail, 0L, TimeUnit.SECONDS);
        }

        private Mail cloneMail(Mail mail) throws MessagingException {
            MailImpl mailImpl = MailImpl.duplicate((Mail)mail);
            mailImpl.setName(mail.getName());
            mailImpl.setState(mail.getState());
            mailImpl.addAllSpecificHeaderForRecipient(mail.getPerRecipientSpecificHeaders());
            Optional.ofNullable(mail.getMessage()).ifPresent((Consumer<MimeMessage>)Throwing.consumer(message -> mailImpl.setMessage(new MimeMessage(message))));
            return mailImpl;
        }

        public Flux<MailQueue.MailQueueItem> deQueue() {
            return this.flux;
        }

        public Mail getLastMail() throws MailQueue.MailQueueException, InterruptedException {
            MemoryMailQueueItem maybeItem = (MemoryMailQueueItem)Iterables.getLast(this.mailItems, null);
            if (maybeItem == null) {
                return null;
            }
            return maybeItem.getMail();
        }

        public long getSize() throws MailQueue.MailQueueException {
            return this.mailItems.size() + this.inProcessingMailItems.size();
        }

        public long flush() throws MailQueue.MailQueueException {
            int count = 0;
            for (MailQueue.MailQueueItem mailQueueItem : this.mailItems) {
                if (!this.mailItems.remove(mailQueueItem)) continue;
                this.enQueue(mailQueueItem.getMail());
                ++count;
            }
            return count;
        }

        public long clear() throws MailQueue.MailQueueException {
            int size = this.mailItems.size();
            this.mailItems.clear();
            return size;
        }

        public long remove(ManageableMailQueue.Type type, String value) throws MailQueue.MailQueueException {
            ImmutableList toBeRemoved = (ImmutableList)this.mailItems.stream().filter(item -> this.shouldRemove((MailQueue.MailQueueItem)item, type, value)).collect(Guavate.toImmutableList());
            toBeRemoved.forEach(this.mailItems::remove);
            return toBeRemoved.size();
        }

        public boolean shouldRemove(MailQueue.MailQueueItem item, ManageableMailQueue.Type type, String value) {
            switch (type) {
                case Name: {
                    return item.getMail().getName().equals(value);
                }
                case Recipient: {
                    return item.getMail().getRecipients().stream().map(MailAddress::asString).anyMatch(value::equals);
                }
                case Sender: {
                    return item.getMail().getMaybeSender().asString().equals(value);
                }
            }
            throw new NotImplementedException("Unknown type " + type);
        }

        private void markProcessingAsFinished(MemoryMailQueueItem item) {
            this.inProcessingMailItems.remove(item);
        }

        public ManageableMailQueue.MailQueueIterator browse() throws MailQueue.MailQueueException {
            final Iterator underlying = ImmutableList.copyOf(this.mailItems).stream().map(item -> new ManageableMailQueue.MailQueueItemView(item.getMail(), ((MemoryMailQueueItem)item).delivery)).iterator();
            return new ManageableMailQueue.MailQueueIterator(){

                public void close() {
                }

                public boolean hasNext() {
                    return underlying.hasNext();
                }

                public ManageableMailQueue.MailQueueItemView next() {
                    return (ManageableMailQueue.MailQueueItemView)underlying.next();
                }
            };
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemoryMailQueue that = (MemoryMailQueue)o;
            return Objects.equal((Object)this.name, (Object)that.name);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name});
        }
    }
}

