/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.netty;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.james.protocols.lib.netty.JMXEnabledOrderedMemoryAwareThreadPoolExecutorMBean;
import org.apache.james.util.concurrent.NamedThreadFactory;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;

public class JMXEnabledOrderedMemoryAwareThreadPoolExecutor
extends OrderedMemoryAwareThreadPoolExecutor
implements JMXEnabledOrderedMemoryAwareThreadPoolExecutorMBean {
    private final String jmxPath;
    private final List<Runnable> inProgress = Collections.synchronizedList(new ArrayList());
    private final ThreadLocal<Long> startTime = new ThreadLocal();
    private long totalTime;
    private int totalTasks;
    private MBeanServer mbeanServer;
    private String mbeanName;

    public JMXEnabledOrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, String jmxPath, String name) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, 30L, TimeUnit.SECONDS, (ThreadFactory)NamedThreadFactory.withName((String)name));
        this.jmxPath = jmxPath;
        this.registerMBean();
    }

    public JMXEnabledOrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize, long keepAliveTime, TimeUnit unit, String jmxPath, String name) {
        super(corePoolSize, maxChannelMemorySize, maxTotalMemorySize, keepAliveTime, unit, (ThreadFactory)NamedThreadFactory.withName((String)name));
        this.jmxPath = jmxPath;
        this.registerMBean();
    }

    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.inProgress.add(r);
        this.startTime.set(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterExecute(Runnable r, Throwable t) {
        long time = System.currentTimeMillis() - this.startTime.get();
        JMXEnabledOrderedMemoryAwareThreadPoolExecutor jMXEnabledOrderedMemoryAwareThreadPoolExecutor = this;
        synchronized (jMXEnabledOrderedMemoryAwareThreadPoolExecutor) {
            this.totalTime += time;
            ++this.totalTasks;
        }
        this.inProgress.remove(r);
        super.afterExecute(r, t);
    }

    private void registerMBean() {
        if (this.jmxPath != null) {
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
            this.mbeanName = this.jmxPath + ",threadpool=" + ((NamedThreadFactory)this.getThreadFactory()).getName();
            try {
                this.mbeanServer.registerMBean(this, new ObjectName(this.mbeanName));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to register mbean", e);
            }
        }
    }

    private void unregisterMBean() {
        if (this.jmxPath != null) {
            try {
                this.mbeanServer.unregisterMBean(new ObjectName(this.mbeanName));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to unregister mbean", e);
            }
        }
    }

    public synchronized void shutdown() {
        if (!this.isShutdown()) {
            this.unregisterMBean();
        }
        super.shutdown();
    }

    public synchronized List<Runnable> shutdownNow() {
        if (!this.isShutdown()) {
            this.unregisterMBean();
        }
        return super.shutdownNow();
    }

    public synchronized int getTotalTasks() {
        return this.totalTasks;
    }

    public synchronized double getAverageTaskTime() {
        return this.totalTasks == 0 ? 0.0 : (double)(this.totalTime / (long)this.totalTasks);
    }

    public int getActiveThreads() {
        return this.getPoolSize();
    }

    public int getActiveTasks() {
        return this.getActiveCount();
    }

    public int getQueuedTasks() {
        return this.getQueue().size();
    }

    public int getMaximalThreads() {
        return this.getMaximumPoolSize();
    }
}

