/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieverepository.api;

import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.james.core.User;
import org.apache.james.sieverepository.api.ScriptContent;
import org.apache.james.sieverepository.api.ScriptName;
import org.apache.james.sieverepository.api.ScriptSummary;
import org.apache.james.sieverepository.api.SieveQuotaRepository;
import org.apache.james.sieverepository.api.exception.DuplicateException;
import org.apache.james.sieverepository.api.exception.IsActiveException;
import org.apache.james.sieverepository.api.exception.QuotaExceededException;
import org.apache.james.sieverepository.api.exception.ScriptNotFoundException;
import org.apache.james.sieverepository.api.exception.StorageException;

public interface SieveRepository
extends SieveQuotaRepository {
    public static final ScriptName NO_SCRIPT_NAME = new ScriptName("");

    public void haveSpace(User var1, ScriptName var2, long var3) throws QuotaExceededException, StorageException;

    public void putScript(User var1, ScriptName var2, ScriptContent var3) throws StorageException, QuotaExceededException;

    public List<ScriptSummary> listScripts(User var1) throws StorageException;

    public ZonedDateTime getActivationDateForActiveScript(User var1) throws StorageException, ScriptNotFoundException;

    public InputStream getActive(User var1) throws ScriptNotFoundException, StorageException;

    public void setActive(User var1, ScriptName var2) throws ScriptNotFoundException, StorageException;

    public InputStream getScript(User var1, ScriptName var2) throws ScriptNotFoundException, StorageException;

    public void deleteScript(User var1, ScriptName var2) throws ScriptNotFoundException, IsActiveException, StorageException;

    public void renameScript(User var1, ScriptName var2, ScriptName var3) throws ScriptNotFoundException, DuplicateException, StorageException;
}

