/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.mail.internet.AddressException;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.User;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.SkipMappingProcessingException;
import org.apache.james.rrt.lib.UserRewritter;

public interface Mapping {
    public static Mapping of(String mapping) {
        Type type = Mapping.detectType(mapping);
        return Mapping.of(type, type.withoutPrefix(mapping));
    }

    public static Mapping of(Type type, String mapping) {
        UserRewritter.MappingUserRewriter rewriter = Mapping.selectRewriter(type);
        IdentityMappingPolicy identityMappingPolicy = Mapping.selectIdentityPolicy(type);
        MailAddressConversionPolicy mailAddressConversionPolicy = Mapping.selectMailAddressConversionPolicy(type);
        return new Impl(type, mapping, rewriter.generateUserRewriter(mapping), identityMappingPolicy, mailAddressConversionPolicy);
    }

    public static UserRewritter.MappingUserRewriter selectRewriter(Type type) {
        switch (type) {
            case Regex: {
                return new UserRewritter.RegexRewriter();
            }
            case Domain: {
                return new UserRewritter.DomainRewriter();
            }
            case Error: {
                return new UserRewritter.ThrowingRewriter();
            }
            case Forward: 
            case Group: 
            case Address: {
                return new UserRewritter.ReplaceRewriter();
            }
        }
        throw new IllegalStateException("unhandle enum type");
    }

    public static IdentityMappingPolicy selectIdentityPolicy(Type type) {
        switch (type) {
            case Regex: 
            case Domain: 
            case Error: 
            case Group: 
            case Address: {
                return IdentityMappingPolicy.Throw;
            }
            case Forward: {
                return IdentityMappingPolicy.ReturnIdentity;
            }
        }
        throw new IllegalStateException("unhandle enum type");
    }

    public static MailAddressConversionPolicy selectMailAddressConversionPolicy(Type type) {
        switch (type) {
            case Regex: 
            case Domain: 
            case Error: {
                return MailAddressConversionPolicy.ToEmpty;
            }
            case Forward: 
            case Group: 
            case Address: {
                return MailAddressConversionPolicy.ToMailAddress;
            }
        }
        throw new IllegalStateException("unhandle enum type");
    }

    public static Mapping address(String mapping) {
        return Mapping.of(Type.Address, mapping);
    }

    public static Mapping regex(String mapping) {
        return Mapping.of(Type.Regex, mapping);
    }

    public static Mapping error(String mapping) {
        return Mapping.of(Type.Error, mapping);
    }

    public static Mapping domain(Domain mapping) {
        return Mapping.of(Type.Domain, mapping.asString());
    }

    public static Mapping forward(String mapping) {
        return Mapping.of(Type.Forward, mapping);
    }

    public static Mapping group(String mapping) {
        return Mapping.of(Type.Group, mapping);
    }

    public static Type detectType(String input) {
        if (input.startsWith(Type.Regex.asPrefix())) {
            return Type.Regex;
        }
        if (input.startsWith(Type.Domain.asPrefix())) {
            return Type.Domain;
        }
        if (input.startsWith(Type.Error.asPrefix())) {
            return Type.Error;
        }
        if (input.startsWith(Type.Forward.asPrefix())) {
            return Type.Forward;
        }
        if (input.startsWith(Type.Group.asPrefix())) {
            return Type.Group;
        }
        return Type.Address;
    }

    public Optional<MailAddress> asMailAddress();

    public Stream<Mapping> handleIdentity(Stream<Mapping> var1);

    public Type getType();

    public String asString();

    public boolean hasDomain();

    public Mapping appendDomainFromThrowingSupplierIfNone(ThrowingDomainSupplier var1) throws RecipientRewriteTableException;

    public Mapping appendDomainIfNone(Supplier<Domain> var1);

    public String getErrorMessage();

    public Optional<User> rewriteUser(User var1) throws AddressException, RecipientRewriteTable.ErrorMappingException;

    public static interface ThrowingDomainSupplier {
        public Domain get() throws RecipientRewriteTableException;
    }

    public static class Impl
    implements Mapping,
    Serializable {
        private final Type type;
        private final String mapping;
        private final UserRewritter rewriter;
        private final IdentityMappingPolicy identityMappingPolicy;
        private final MailAddressConversionPolicy mailAddressConversionPolicy;

        private Impl(Type type, String mapping, UserRewritter rewriter, IdentityMappingPolicy identityMappingBehaviour, MailAddressConversionPolicy mailAddressConversionPolicy) {
            Preconditions.checkNotNull((Object)((Object)type));
            Preconditions.checkNotNull((Object)mapping);
            this.type = type;
            this.mapping = mapping;
            this.rewriter = rewriter;
            this.identityMappingPolicy = identityMappingBehaviour;
            this.mailAddressConversionPolicy = mailAddressConversionPolicy;
        }

        @Override
        public String asString() {
            return this.type.asPrefix() + this.mapping;
        }

        @Override
        public boolean hasDomain() {
            return this.mapping.contains("@");
        }

        @Override
        public Mapping appendDomainIfNone(Supplier<Domain> domain) {
            Preconditions.checkNotNull(domain);
            if (this.hasDomain()) {
                return this;
            }
            return this.appendDomain(domain.get());
        }

        @Override
        public Mapping appendDomainFromThrowingSupplierIfNone(ThrowingDomainSupplier supplier) throws RecipientRewriteTableException {
            Preconditions.checkNotNull((Object)supplier);
            if (this.hasDomain()) {
                return this;
            }
            return this.appendDomain(supplier.get());
        }

        private Mapping appendDomain(Domain domain) {
            return Mapping.of(this.type, this.mapping + "@" + domain.asString());
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public String getErrorMessage() {
            Preconditions.checkState((this.getType() == Type.Error ? 1 : 0) != 0);
            return this.mapping;
        }

        @Override
        public Optional<User> rewriteUser(User user) throws AddressException, RecipientRewriteTable.ErrorMappingException {
            return this.rewriter.rewrite(user);
        }

        @Override
        public Stream<Mapping> handleIdentity(Stream<Mapping> nonRecursiveResult) {
            return this.identityMappingPolicy.handleIdentity(nonRecursiveResult);
        }

        @Override
        public Optional<MailAddress> asMailAddress() {
            return this.mailAddressConversionPolicy.convert(this.mapping);
        }

        public final boolean equals(Object other) {
            if (other instanceof Impl) {
                Impl otherMapping = (Impl)other;
                return Objects.equal((Object)((Object)this.type), (Object)((Object)otherMapping.type)) && Objects.equal((Object)this.mapping, (Object)otherMapping.mapping);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.mapping});
        }

        public String toString() {
            return "Mapping{type=" + (Object)((Object)this.type) + " mapping=" + this.mapping + "}";
        }
    }

    public static enum IdentityMappingPolicy {
        Throw{

            @Override
            public Stream<Mapping> handleIdentity(Stream<Mapping> mapping) {
                throw new SkipMappingProcessingException();
            }
        }
        ,
        ReturnIdentity{

            @Override
            public Stream<Mapping> handleIdentity(Stream<Mapping> mapping) {
                return mapping;
            }
        };


        public abstract Stream<Mapping> handleIdentity(Stream<Mapping> var1);
    }

    public static enum Type {
        Regex("regex:"),
        Domain("domain:"),
        Error("error:"),
        Forward("forward:"),
        Group("group:"),
        Address("");

        private final String asPrefix;

        private Type(String asPrefix) {
            this.asPrefix = asPrefix;
        }

        public String asPrefix() {
            return this.asPrefix;
        }

        public String withoutPrefix(String input) {
            Preconditions.checkArgument((boolean)input.startsWith(this.asPrefix));
            return input.substring(this.asPrefix.length());
        }

        public static boolean hasPrefix(String mapping) {
            return mapping.startsWith(Regex.asPrefix()) || mapping.startsWith(Domain.asPrefix()) || mapping.startsWith(Error.asPrefix()) || mapping.startsWith(Forward.asPrefix()) || mapping.startsWith(Group.asPrefix());
        }
    }

    public static enum MailAddressConversionPolicy {
        ToEmpty{

            @Override
            Optional<MailAddress> convert(String mapping) {
                return Optional.empty();
            }
        }
        ,
        ToMailAddress{

            @Override
            Optional<MailAddress> convert(String mapping) {
                try {
                    return Optional.of(new MailAddress(mapping));
                }
                catch (AddressException e) {
                    return Optional.empty();
                }
            }
        };


        abstract Optional<MailAddress> convert(String var1);
    }
}

