/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.samples.dom;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Date;
import javax.imageio.ImageIO;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.message.BodyPartBuilder;
import org.apache.james.mime4j.message.DefaultMessageWriter;
import org.apache.james.mime4j.message.MessageBuilder;
import org.apache.james.mime4j.message.MultipartBuilder;
import org.apache.james.mime4j.storage.Storage;
import org.apache.james.mime4j.storage.StorageBodyFactory;
import org.apache.james.mime4j.storage.StorageOutputStream;
import org.apache.james.mime4j.storage.StorageProvider;
import org.apache.james.mime4j.stream.NameValuePair;

public class MultipartMessage {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        StorageBodyFactory bodyFactory = new StorageBodyFactory();
        Message message = MessageBuilder.create().setFrom("John Doe <jdoe@machine.example>").setTo("Mary Smith <mary@example.net>").setSubject("An image for you").setDate(new Date()).generateMessageId(InetAddress.getLocalHost().getCanonicalHostName()).setBody(MultipartBuilder.create((String)"mixed").use((BodyFactory)bodyFactory).setPreamble("This is a multi-part message in MIME format.").addBodyPart((Entity)BodyPartBuilder.create().use((BodyFactory)bodyFactory).setBody("Why so serious?", Charsets.UTF_8).setContentTransferEncoding("quoted-printable").build()).addBodyPart((Entity)BodyPartBuilder.create().use((BodyFactory)bodyFactory).setBody(MultipartMessage.createImageBody(bodyFactory, MultipartMessage.renderSampleImage())).setContentType("image/png", new NameValuePair[0]).setContentTransferEncoding("base64").setContentDisposition("attachment", "smiley.png").build()).build()).build();
        try {
            DefaultMessageWriter writer = new DefaultMessageWriter();
            writer.writeMessage(message, (OutputStream)System.out);
        }
        finally {
            message.dispose();
        }
    }

    private static BinaryBody createImageBody(StorageBodyFactory bodyFactory, BufferedImage image) throws IOException {
        StorageProvider storageProvider = bodyFactory.getStorageProvider();
        Storage storage = MultipartMessage.storeImage(storageProvider, image, "png");
        return bodyFactory.binaryBody(storage);
    }

    private static Storage storeImage(StorageProvider storageProvider, BufferedImage image, String formatName) throws IOException {
        StorageOutputStream out = storageProvider.createStorageOutputStream();
        ImageIO.write((RenderedImage)image, formatName, (OutputStream)out);
        return out.toStorage();
    }

    private static BufferedImage renderSampleImage() {
        System.setProperty("java.awt.headless", "true");
        int size = 100;
        BufferedImage img = new BufferedImage(100, 100, 10);
        Graphics2D gfx = img.createGraphics();
        gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gfx.setStroke(new BasicStroke(2.5f, 1, 1));
        gfx.setColor(Color.BLACK);
        gfx.setBackground(Color.WHITE);
        gfx.clearRect(0, 0, 100, 100);
        int b = 3;
        gfx.drawOval(b, b, 99 - 2 * b, 99 - 2 * b);
        int esz = 14;
        int ex = 27;
        gfx.drawOval(ex, ex, esz, esz);
        gfx.drawOval(99 - esz - ex, ex, esz, esz);
        b = 20;
        gfx.drawArc(b, b, 99 - 2 * b, 99 - 2 * b, 200, 140);
        return img;
    }
}

