/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class SubtreeExcludingValidator
extends DefaultValidator {
    private final Validator validator;
    private final String head;
    private final List<String> tail;

    protected SubtreeExcludingValidator(Validator validator, List<String> path) {
        this.validator = (Validator)Preconditions.checkNotNull((Object)validator);
        Preconditions.checkNotNull(path);
        Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0);
        this.head = path.get(0);
        this.tail = path.subList(1, path.size());
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        this.validator.propertyAdded(after);
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        this.validator.propertyChanged(before, after);
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        this.validator.propertyDeleted(before);
    }

    @Override
    public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
        this.validator.childNodeAdded(name, after);
        return this.descend(name);
    }

    @Override
    public Validator childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        this.validator.childNodeChanged(name, before, after);
        return this.descend(name);
    }

    @Override
    public Validator childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        this.validator.childNodeDeleted(name, before);
        return this.descend(name);
    }

    private Validator descend(String name) {
        if (!this.head.equals(name)) {
            return this.validator;
        }
        if (this.tail.isEmpty()) {
            return null;
        }
        return this.createValidator(this.validator, this.tail);
    }

    protected SubtreeExcludingValidator createValidator(Validator validator, List<String> path) {
        return new SubtreeExcludingValidator(validator, path);
    }
}

