/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;

class MemoryNodeState
extends AbstractNodeState {
    private final Map<String, PropertyState> properties;
    private final Map<String, NodeState> nodes;

    public MemoryNodeState(Map<String, PropertyState> properties, Map<String, NodeState> nodes) {
        this.properties = properties;
        this.nodes = nodes;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean hasProperty(@NotNull String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public PropertyState getProperty(@NotNull String name) {
        return this.properties.get(name);
    }

    @Override
    public long getPropertyCount() {
        return this.properties.size();
    }

    @Override
    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        return this.properties.values();
    }

    @Override
    public boolean hasChildNode(@NotNull String name) {
        return this.nodes.containsKey(name);
    }

    @Override
    @NotNull
    public NodeState getChildNode(@NotNull String name) {
        NodeState state = this.nodes.get(name);
        if (state == null) {
            MemoryNodeState.checkValidName(name);
            state = EmptyNodeState.MISSING_NODE;
        }
        return state;
    }

    @Override
    public long getChildNodeCount(long max) {
        return this.nodes.size();
    }

    @NotNull
    public Iterable<ChildNodeEntry> getChildNodeEntries() {
        return MemoryChildNodeEntry.iterable(this.nodes.entrySet());
    }

    @Override
    @NotNull
    public NodeBuilder builder() {
        return new MemoryNodeBuilder(this);
    }

    @Override
    public boolean compareAgainstBaseState(NodeState base, NodeStateDiff diff) {
        if (base == EmptyNodeState.EMPTY_NODE || !base.exists()) {
            return EmptyNodeState.compareAgainstEmptyState(this, diff);
        }
        HashMap<String, PropertyState> newProperties = new HashMap<String, PropertyState>(this.properties);
        for (PropertyState propertyState : base.getProperties()) {
            PropertyState propertyState2 = (PropertyState)newProperties.remove(propertyState.getName());
            if (!(propertyState2 == null ? !diff.propertyDeleted(propertyState) : !propertyState2.equals(propertyState) && !diff.propertyChanged(propertyState, propertyState2))) continue;
            return false;
        }
        for (PropertyState propertyState : newProperties.values()) {
            if (diff.propertyAdded(propertyState)) continue;
            return false;
        }
        HashMap<String, NodeState> newNodes = new HashMap<String, NodeState>(this.nodes);
        for (ChildNodeEntry childNodeEntry : base.getChildNodeEntries()) {
            String name = childNodeEntry.getName();
            NodeState before = childNodeEntry.getNodeState();
            NodeState after = (NodeState)newNodes.remove(name);
            if (!(after == null ? !diff.childNodeDeleted(name, before) : after != before && !diff.childNodeChanged(name, before, after))) continue;
            return false;
        }
        for (Map.Entry entry : newNodes.entrySet()) {
            if (diff.childNodeAdded((String)entry.getKey(), (NodeState)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    static MemoryNodeState wrap(NodeState state) {
        if (state instanceof MemoryNodeState) {
            return (MemoryNodeState)state;
        }
        HashMap properties = Maps.newHashMap();
        for (PropertyState propertyState : state.getProperties()) {
            properties.put(propertyState.getName(), propertyState);
        }
        HashMap nodes = Maps.newHashMap();
        for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
            nodes.put(childNodeEntry.getName(), childNodeEntry.getNodeState());
        }
        return new MemoryNodeState(properties, nodes);
    }
}

