/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.client;

import java.util.function.Supplier;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.segment.CancelableDiff;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.standby.client.BlobFetchTimeoutException;
import org.apache.jackrabbit.oak.segment.standby.client.BlobProcessor;
import org.apache.jackrabbit.oak.segment.standby.client.BlobTypeUnknownException;
import org.apache.jackrabbit.oak.segment.standby.client.BlobWriteException;
import org.apache.jackrabbit.oak.segment.standby.client.RemoteBlobProcessor;
import org.apache.jackrabbit.oak.segment.standby.client.StandbyClient;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StandbyDiff
implements NodeStateDiff {
    private static final Logger log = LoggerFactory.getLogger(StandbyDiff.class);
    private final NodeBuilder builder;
    private final FileStore store;
    private final StandbyClient client;
    private final String path;
    private final Supplier<Boolean> running;
    private final BlobProcessor blobProcessor;

    StandbyDiff(NodeBuilder builder, FileStore store, StandbyClient client, Supplier<Boolean> running) {
        this(builder, store, client, "/", running);
    }

    private static BlobProcessor newBinaryFetcher(BlobStore blobStore, StandbyClient client) {
        if (blobStore == null) {
            return blob -> {};
        }
        return new RemoteBlobProcessor(blobStore, client::getBlob);
    }

    private StandbyDiff(NodeBuilder builder, FileStore store, StandbyClient client, String path, Supplier<Boolean> running) {
        this.builder = builder;
        this.store = store;
        this.client = client;
        this.path = path;
        this.running = running;
        this.blobProcessor = StandbyDiff.newBinaryFetcher(store.getBlobStore(), client);
    }

    public boolean propertyAdded(PropertyState after) {
        this.builder.setProperty(after);
        return true;
    }

    public boolean propertyChanged(PropertyState before, PropertyState after) {
        this.builder.setProperty(after);
        return true;
    }

    public boolean propertyDeleted(PropertyState before) {
        this.builder.removeProperty(before.getName());
        return true;
    }

    public boolean childNodeAdded(String name, NodeState after) {
        SegmentNodeState processed = this.process(name, EmptyNodeState.EMPTY_NODE, after, EmptyNodeState.EMPTY_NODE.builder());
        if (processed != null) {
            this.builder.setChildNode(name, (NodeState)processed);
            return true;
        }
        return false;
    }

    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        SegmentNodeState processed = this.process(name, before, after, this.builder.getChildNode(name));
        if (processed != null) {
            this.builder.setChildNode(name, (NodeState)processed);
            return true;
        }
        return false;
    }

    public boolean childNodeDeleted(String name, NodeState before) {
        this.builder.getChildNode(name).remove();
        return true;
    }

    public SegmentNodeState process(String name, NodeState before, NodeState after, NodeBuilder onto) {
        return new StandbyDiff(onto, this.store, this.client, this.path + name + "/", this.running).diff(name, before, after);
    }

    SegmentNodeState diff(String name, NodeState before, NodeState after) {
        if (after instanceof SegmentNodeState) {
            if ("checkpoints".equals(name)) {
                return (SegmentNodeState)after;
            }
            if (this.store.getBlobStore() == null) {
                return (SegmentNodeState)after;
            }
            for (PropertyState propertyState : after.getProperties()) {
                this.processBinary(propertyState);
            }
            boolean success = after.compareAgainstBaseState(before, (NodeStateDiff)new CancelableDiff(this, this.newCanceledSupplier()));
            if (success) {
                return (SegmentNodeState)after;
            }
            return null;
        }
        return null;
    }

    private Supplier<Boolean> newCanceledSupplier() {
        return new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return StandbyDiff.this.running.get() == false;
            }
        };
    }

    private PropertyState processBinary(PropertyState property) {
        Type type = property.getType();
        if (type == Type.BINARY) {
            this.processBinary((Blob)property.getValue(Type.BINARY), property.getName());
        } else if (type == Type.BINARIES) {
            for (Blob blob : (Iterable)property.getValue(Type.BINARIES)) {
                this.processBinary(blob, property.getName());
            }
        }
        return property;
    }

    private void processBinary(Blob b, String propertyName) {
        try {
            this.blobProcessor.processBinary(b);
        }
        catch (BlobFetchTimeoutException e) {
            String message = String.format("Unable to load remote blob %s at %s#%s in %dms. Please increase the timeout and try again.", e.getBlobId(), this.path, propertyName, this.client.getReadTimeoutMs());
            throw new IllegalStateException(message, e);
        }
        catch (BlobWriteException e) {
            String message = String.format("Unable to persist blob %s at %s#%s", e.getBlobId(), this.path, propertyName);
            throw new IllegalStateException(message, e);
        }
        catch (BlobTypeUnknownException e) {
            log.warn("Unknown Blob {} at {}, ignoring", (Object)b.getClass().getName(), (Object)(this.path + "#" + propertyName));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

