/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.client;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.jackrabbit.oak.commons.time.Stopwatch;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentIdProvider;
import org.apache.jackrabbit.oak.segment.SegmentNodeBuilder;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.standby.client.StandbyClient;
import org.apache.jackrabbit.oak.segment.standby.client.StandbyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StandbyClientSyncExecution {
    private static final Logger log = LoggerFactory.getLogger(StandbyClientSyncExecution.class);
    private final FileStore store;
    private final SegmentIdProvider idProvider;
    private final Supplier<Boolean> running;

    StandbyClientSyncExecution(FileStore store, Supplier<Boolean> running) {
        this.store = store;
        this.idProvider = store.getSegmentIdProvider();
        this.running = running;
    }

    void execute(StandbyClient client) throws Exception {
        RecordId remoteHead = this.getHead(client);
        if (remoteHead == null) {
            log.error("Unable to fetch remote head");
            return;
        }
        if (remoteHead.equals(this.store.getHead().getRecordId())) {
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        SegmentNodeState before = this.store.getHead();
        SegmentNodeBuilder builder = before.builder();
        SegmentNodeState current = this.newSegmentNodeState(remoteHead);
        this.compareAgainstBaseState(client, current, before, builder);
        this.store.getRevisions().setHead(before.getRecordId(), remoteHead, new Revisions.Option[0]);
        log.info("Updated head state in {}", (Object)stopwatch);
    }

    @Nullable
    private RecordId getHead(StandbyClient client) throws Exception {
        String head = client.getHead();
        if (head == null) {
            return null;
        }
        return RecordId.fromString(this.idProvider, head);
    }

    private SegmentNodeState newSegmentNodeState(RecordId id) {
        return this.store.getReader().readNode(id);
    }

    private void compareAgainstBaseState(StandbyClient client, SegmentNodeState current, SegmentNodeState before, SegmentNodeBuilder builder) throws Exception {
        while (true) {
            try {
                current.compareAgainstBaseState(before, new StandbyDiff((NodeBuilder)builder, this.store, client, this.running));
                return;
            }
            catch (SegmentNotFoundException e) {
                log.debug("Found missing segment {}", (Object)e.getSegmentId());
                this.copySegmentHierarchyFromPrimary(client, UUID.fromString(e.getSegmentId()));
                continue;
            }
            break;
        }
    }

    private void copySegmentHierarchyFromPrimary(StandbyClient client, UUID segmentId) throws Exception {
        HashSet<UUID> visited = new HashSet<UUID>();
        LinkedList<UUID> bulk = new LinkedList<UUID>();
        LinkedList<UUID> data = new LinkedList<UUID>();
        this.deriveTopologicalOrder(client, segmentId, visited, data, bulk);
        for (UUID id : bulk) {
            log.info("Copying bulk segment {} from primary", (Object)id);
            this.copySegmentFromPrimary(client, id);
        }
        for (UUID id : data) {
            log.info("Copying data segment {} from primary", (Object)id);
            this.copySegmentFromPrimary(client, id);
        }
    }

    private void deriveTopologicalOrder(StandbyClient client, UUID id, Set<UUID> visited, List<UUID> data, List<UUID> bulk) throws Exception {
        if (visited.contains(id) || this.isLocal(id)) {
            return;
        }
        log.debug("Inspecting segment {}", (Object)id);
        visited.add(id);
        if (SegmentId.isDataSegmentId(id.getLeastSignificantBits())) {
            for (String s : this.readReferences(client, id)) {
                UUID referenced = UUID.fromString(s);
                log.debug("Found reference from {} to {}", (Object)id, (Object)referenced);
                this.deriveTopologicalOrder(client, referenced, visited, data, bulk);
            }
            data.add(id);
        } else {
            bulk.add(id);
        }
    }

    private Iterable<String> readReferences(StandbyClient client, UUID id) throws InterruptedException {
        Iterable<String> references = client.getReferences(id.toString());
        if (references == null) {
            throw new IllegalStateException(String.format("Unable to read references of segment %s from primary", id));
        }
        return references;
    }

    private boolean isLocal(UUID id) {
        return this.store.containsSegment(this.idProvider.newSegmentId(id.getMostSignificantBits(), id.getLeastSignificantBits()));
    }

    private void copySegmentFromPrimary(StandbyClient client, UUID uuid) throws Exception {
        byte[] data = client.getSegment(uuid.toString());
        if (data == null) {
            throw new IllegalStateException("Unable to read segment " + String.valueOf(uuid));
        }
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        SegmentId segmentId = this.idProvider.newSegmentId(msb, lsb);
        this.store.writeSegment(segmentId, data, 0, data.length);
    }
}

