/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.jackrabbit.guava.common.cache.CacheStats;
import org.apache.jackrabbit.guava.common.cache.Weigher;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.segment.CacheWeights;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PriorityCache<K, V> {
    private final int rehash;
    private final Entry<?, ?>[] entries;
    private final AtomicInteger[] costs;
    private final AtomicInteger[] evictions;
    private final LongAdder hitCount = new LongAdder();
    private final LongAdder missCount = new LongAdder();
    private final LongAdder loadCount = new LongAdder();
    private final LongAdder loadExceptionCount = new LongAdder();
    private final LongAdder evictionCount = new LongAdder();
    private final LongAdder size = new LongAdder();
    @NotNull
    private final Segment[] segments;
    @NotNull
    private final Weigher<K, V> weigher;
    private final AtomicLong weight = new AtomicLong();

    public static <K, V> Supplier<PriorityCache<K, V>> factory(int size, @NotNull Weigher<K, V> weigher) {
        Validate.checkArgument((Integer.bitCount(size) == 1 ? 1 : 0) != 0);
        Objects.requireNonNull(weigher);
        return () -> new PriorityCache(size, weigher);
    }

    public static <K, V> Supplier<PriorityCache<K, V>> factory(int size) {
        Validate.checkArgument((Integer.bitCount(size) == 1 ? 1 : 0) != 0);
        return () -> new PriorityCache(size);
    }

    public static long nextPowerOfTwo(int size) {
        return 1L << (int)(64L - (long)Long.numberOfLeadingZeros((long)Math.max(1, size) - 1L));
    }

    PriorityCache(int size, int rehash) {
        this(size, rehash, CacheWeights.noopWeigher());
    }

    public PriorityCache(int size, int rehash, @NotNull Weigher<K, V> weigher) {
        this(size, rehash, weigher, 1024);
    }

    public PriorityCache(int size, int rehash, @NotNull Weigher<K, V> weigher, int numSegments) {
        Validate.checkArgument((Integer.bitCount(size) == 1 ? 1 : 0) != 0);
        Validate.checkArgument((rehash >= 0 ? 1 : 0) != 0);
        Validate.checkArgument((rehash < 32 - Integer.numberOfTrailingZeros(size) ? 1 : 0) != 0);
        this.rehash = rehash;
        this.entries = new Entry[size];
        Arrays.fill(this.entries, Entry.NULL);
        this.weigher = Objects.requireNonNull(weigher);
        numSegments = Math.min(numSegments, size);
        Validate.checkArgument((size % numSegments == 0 ? 1 : 0) != 0, (String)"Cache size is not a multiple of its segment count.");
        this.segments = new Segment[numSegments];
        for (int s = 0; s < numSegments; ++s) {
            this.segments[s] = new Segment();
        }
        this.costs = new AtomicInteger[256];
        this.evictions = new AtomicInteger[256];
        for (int i = 0; i < 256; ++i) {
            this.costs[i] = new AtomicInteger();
            this.evictions[i] = new AtomicInteger();
        }
    }

    public PriorityCache(int size, @NotNull Weigher<K, V> weigher) {
        this(size, 31 - Integer.numberOfTrailingZeros(size), weigher);
    }

    public PriorityCache(int size) {
        this(size, 31 - Integer.numberOfTrailingZeros(size));
    }

    private int project(int hashCode, int iteration) {
        return hashCode >> iteration & this.entries.length - 1;
    }

    private Segment getSegment(int index) {
        int entriesPerSegment = this.entries.length / this.segments.length;
        return this.segments[index / entriesPerSegment];
    }

    public long size() {
        return this.size.sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(@NotNull K key, @NotNull V value, int generation, byte initialCost) {
        int hashCode = key.hashCode();
        byte cheapest = initialCost;
        int index = -1;
        boolean eviction = false;
        ReentrantLock lockedSegment = null;
        try {
            for (int k = 0; k <= this.rehash; ++k) {
                Entry<?, ?> entry;
                int i = this.project(hashCode, k);
                Segment segment = this.getSegment(i);
                if (segment != lockedSegment) {
                    if (lockedSegment != null) {
                        lockedSegment.unlock();
                    }
                    lockedSegment = segment;
                    lockedSegment.lock();
                }
                if ((entry = this.entries[i]) == Entry.NULL) {
                    index = i;
                    eviction = false;
                    break;
                }
                if (entry.generation <= generation && key.equals(entry.key)) {
                    index = i;
                    initialCost = entry.cost;
                    if (initialCost < 127) {
                        initialCost = (byte)(initialCost + 1);
                    }
                    eviction = false;
                    break;
                }
                if (entry.generation < generation) {
                    index = i;
                    eviction = false;
                    break;
                }
                if (entry.cost >= cheapest) continue;
                cheapest = entry.cost;
                index = i;
                eviction = true;
            }
            if (index >= 0) {
                Entry<?, ?> oldEntry = this.entries[index];
                Entry<K, V> newEntry = new Entry<K, V>(key, value, generation, initialCost);
                this.entries[index] = newEntry;
                this.loadCount.increment();
                this.costs[initialCost - -128].incrementAndGet();
                if (oldEntry != Entry.NULL) {
                    this.costs[oldEntry.cost - -128].decrementAndGet();
                    if (eviction) {
                        this.evictions[oldEntry.cost - -128].incrementAndGet();
                        this.evictionCount.increment();
                    }
                    this.weight.addAndGet(-this.weighEntry(oldEntry));
                } else {
                    this.size.increment();
                }
                this.weight.addAndGet(this.weighEntry(newEntry));
                boolean bl = true;
                return bl;
            }
            this.loadExceptionCount.increment();
            boolean bl = false;
            return bl;
        }
        finally {
            if (lockedSegment != null) {
                lockedSegment.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public V get(@NotNull K key, int generation) {
        int hashCode = key.hashCode();
        for (int k = 0; k <= this.rehash; ++k) {
            int i = this.project(hashCode, k);
            Segment segment = this.getSegment(i);
            segment.lock();
            try {
                Entry<?, ?> entry = this.entries[i];
                if (generation != entry.generation || !key.equals(entry.key)) continue;
                if (entry.cost < 127) {
                    this.costs[entry.cost - -128].decrementAndGet();
                    entry.cost = (byte)(entry.cost + 1);
                    this.costs[entry.cost - -128].incrementAndGet();
                }
                this.hitCount.increment();
                Object v = entry.value;
                return v;
            }
            finally {
                segment.unlock();
            }
        }
        this.missCount.increment();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeGenerations(@NotNull Predicate<Integer> purge) {
        int numSegments = this.segments.length;
        int entriesPerSegment = this.entries.length / numSegments;
        for (int s = 0; s < numSegments; ++s) {
            this.segments[s].lock();
            try {
                for (int i = 0; i < entriesPerSegment; ++i) {
                    int j = i + s * entriesPerSegment;
                    Entry<?, ?> entry = this.entries[j];
                    if (entry == Entry.NULL || !purge.test(entry.generation)) continue;
                    this.entries[j] = Entry.NULL;
                    this.size.decrement();
                    this.weight.addAndGet(-this.weighEntry(entry));
                }
                continue;
            }
            finally {
                this.segments[s].unlock();
            }
        }
    }

    private int weighEntry(Entry<?, ?> entry) {
        return this.weigher.weigh(entry.key, entry.value);
    }

    public String toString() {
        return "PriorityCache{ costs=" + PriorityCache.toString(this.costs) + ", evictions=" + PriorityCache.toString(this.evictions) + " }";
    }

    private static String toString(AtomicInteger[] ints) {
        StringBuilder b = new StringBuilder("[");
        String sep = "";
        for (int i = 0; i < ints.length; ++i) {
            int value = ints[i].get();
            if (value <= 0) continue;
            b.append(sep).append(i).append("->").append(value);
            sep = ",";
        }
        return b.append(']').toString();
    }

    @NotNull
    public CacheStats getStats() {
        return new CacheStats(this.hitCount.sum(), this.missCount.sum(), this.loadCount.sum(), this.loadExceptionCount.sum(), 0L, this.evictionCount.sum());
    }

    public long estimateCurrentWeight() {
        return this.weight.get();
    }

    private static class Entry<K, V> {
        static final Entry<Void, Void> NULL = new Entry<Object, Object>(null, null, -1, -128);
        final K key;
        final V value;
        final int generation;
        byte cost;

        public Entry(K key, V value, int generation, byte cost) {
            this.key = key;
            this.value = value;
            this.generation = generation;
            this.cost = cost;
        }

        public String toString() {
            return this == NULL ? "NULL" : "Entry{" + String.valueOf(this.key) + "->" + String.valueOf(this.value) + " @" + this.generation + ", $" + this.cost + "}";
        }
    }

    private static class Segment
    extends ReentrantLock {
        private Segment() {
        }
    }
}

